package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHistoryDataList invokes the ltl.GetHistoryDataList API synchronously
func (client *Client) GetHistoryDataList(request *GetHistoryDataListRequest) (response *GetHistoryDataListResponse, err error) {
	response = CreateGetHistoryDataListResponse()
	err = client.DoAction(request, response)
	return
}

// GetHistoryDataListWithChan invokes the ltl.GetHistoryDataList API asynchronously
func (client *Client) GetHistoryDataListWithChan(request *GetHistoryDataListRequest) (<-chan *GetHistoryDataListResponse, <-chan error) {
	responseChan := make(chan *GetHistoryDataListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHistoryDataList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHistoryDataListWithCallback invokes the ltl.GetHistoryDataList API asynchronously
func (client *Client) GetHistoryDataListWithCallback(request *GetHistoryDataListRequest, callback func(response *GetHistoryDataListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHistoryDataListResponse
		var err error
		defer close(result)
		response, err = client.GetHistoryDataList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHistoryDataListRequest is the request struct for api GetHistoryDataList
type GetHistoryDataListRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	ApiVersion  string           `position:"Query" name:"ApiVersion"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	ProductKey  string           `position:"Query" name:"ProductKey"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Key         string           `position:"Query" name:"Key"`
}

// GetHistoryDataListResponse is the response struct for api GetHistoryDataList
type GetHistoryDataListResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Message   string                   `json:"Message" xml:"Message"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Success   bool                     `json:"Success" xml:"Success"`
	Data      DataInGetHistoryDataList `json:"Data" xml:"Data"`
}

// CreateGetHistoryDataListRequest creates a request to invoke GetHistoryDataList API
func CreateGetHistoryDataListRequest() (request *GetHistoryDataListRequest) {
	request = &GetHistoryDataListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "GetHistoryDataList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHistoryDataListResponse creates a response to parse from GetHistoryDataList response
func CreateGetHistoryDataListResponse() (response *GetHistoryDataListResponse) {
	response = &GetHistoryDataListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
