package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMPCoSPhase invokes the ltl.CreateMPCoSPhase API synchronously
func (client *Client) CreateMPCoSPhase(request *CreateMPCoSPhaseRequest) (response *CreateMPCoSPhaseResponse, err error) {
	response = CreateCreateMPCoSPhaseResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMPCoSPhaseWithChan invokes the ltl.CreateMPCoSPhase API asynchronously
func (client *Client) CreateMPCoSPhaseWithChan(request *CreateMPCoSPhaseRequest) (<-chan *CreateMPCoSPhaseResponse, <-chan error) {
	responseChan := make(chan *CreateMPCoSPhaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMPCoSPhase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMPCoSPhaseWithCallback invokes the ltl.CreateMPCoSPhase API asynchronously
func (client *Client) CreateMPCoSPhaseWithCallback(request *CreateMPCoSPhaseRequest, callback func(response *CreateMPCoSPhaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMPCoSPhaseResponse
		var err error
		defer close(result)
		response, err = client.CreateMPCoSPhase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMPCoSPhaseRequest is the request struct for api CreateMPCoSPhase
type CreateMPCoSPhaseRequest struct {
	*requests.RpcRequest
	Name         string `position:"Query" name:"Name"`
	PhaseGroupId string `position:"Query" name:"PhaseGroupId"`
	ApiVersion   string `position:"Query" name:"ApiVersion"`
	Remark       string `position:"Query" name:"Remark"`
	BizChainId   string `position:"Query" name:"BizChainId"`
}

// CreateMPCoSPhaseResponse is the response struct for api CreateMPCoSPhase
type CreateMPCoSPhaseResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateMPCoSPhaseRequest creates a request to invoke CreateMPCoSPhase API
func CreateCreateMPCoSPhaseRequest() (request *CreateMPCoSPhaseRequest) {
	request = &CreateMPCoSPhaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "CreateMPCoSPhase", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMPCoSPhaseResponse creates a response to parse from CreateMPCoSPhase response
func CreateCreateMPCoSPhaseResponse() (response *CreateMPCoSPhaseResponse) {
	response = &CreateMPCoSPhaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
