package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendLiveMessageUser invokes the live.SendLiveMessageUser API synchronously
func (client *Client) SendLiveMessageUser(request *SendLiveMessageUserRequest) (response *SendLiveMessageUserResponse, err error) {
	response = CreateSendLiveMessageUserResponse()
	err = client.DoAction(request, response)
	return
}

// SendLiveMessageUserWithChan invokes the live.SendLiveMessageUser API asynchronously
func (client *Client) SendLiveMessageUserWithChan(request *SendLiveMessageUserRequest) (<-chan *SendLiveMessageUserResponse, <-chan error) {
	responseChan := make(chan *SendLiveMessageUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendLiveMessageUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendLiveMessageUserWithCallback invokes the live.SendLiveMessageUser API asynchronously
func (client *Client) SendLiveMessageUserWithCallback(request *SendLiveMessageUserRequest, callback func(response *SendLiveMessageUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendLiveMessageUserResponse
		var err error
		defer close(result)
		response, err = client.SendLiveMessageUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendLiveMessageUserRequest is the request struct for api SendLiveMessageUser
type SendLiveMessageUserRequest struct {
	*requests.RpcRequest
	DataCenter string           `position:"Query" name:"DataCenter"`
	MsgTid     string           `position:"Query" name:"MsgTid"`
	Body       string           `position:"Query" name:"Body"`
	SenderId   string           `position:"Query" name:"SenderId"`
	ReceiverId string           `position:"Query" name:"ReceiverId"`
	AppId      string           `position:"Query" name:"AppId"`
	SenderInfo string           `position:"Query" name:"SenderInfo"`
	MsgType    requests.Integer `position:"Query" name:"MsgType"`
}

// SendLiveMessageUserResponse is the response struct for api SendLiveMessageUser
type SendLiveMessageUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendLiveMessageUserRequest creates a request to invoke SendLiveMessageUser API
func CreateSendLiveMessageUserRequest() (request *SendLiveMessageUserRequest) {
	request = &SendLiveMessageUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SendLiveMessageUser", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendLiveMessageUserResponse creates a response to parse from SendLiveMessageUser response
func CreateSendLiveMessageUserResponse() (response *SendLiveMessageUserResponse) {
	response = &SendLiveMessageUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
