package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenLiveShift invokes the live.OpenLiveShift API synchronously
func (client *Client) OpenLiveShift(request *OpenLiveShiftRequest) (response *OpenLiveShiftResponse, err error) {
	response = CreateOpenLiveShiftResponse()
	err = client.DoAction(request, response)
	return
}

// OpenLiveShiftWithChan invokes the live.OpenLiveShift API asynchronously
func (client *Client) OpenLiveShiftWithChan(request *OpenLiveShiftRequest) (<-chan *OpenLiveShiftResponse, <-chan error) {
	responseChan := make(chan *OpenLiveShiftResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenLiveShift(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenLiveShiftWithCallback invokes the live.OpenLiveShift API asynchronously
func (client *Client) OpenLiveShiftWithCallback(request *OpenLiveShiftRequest, callback func(response *OpenLiveShiftResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenLiveShiftResponse
		var err error
		defer close(result)
		response, err = client.OpenLiveShift(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenLiveShiftRequest is the request struct for api OpenLiveShift
type OpenLiveShiftRequest struct {
	*requests.RpcRequest
	Duration        requests.Integer `position:"Query" name:"Duration"`
	AppName         string           `position:"Query" name:"AppName"`
	StreamName      string           `position:"Query" name:"StreamName"`
	IgnoreTranscode requests.Boolean `position:"Query" name:"IgnoreTranscode"`
	DomainName      string           `position:"Query" name:"DomainName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	Vision          requests.Integer `position:"Query" name:"Vision"`
}

// OpenLiveShiftResponse is the response struct for api OpenLiveShift
type OpenLiveShiftResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenLiveShiftRequest creates a request to invoke OpenLiveShift API
func CreateOpenLiveShiftRequest() (request *OpenLiveShiftRequest) {
	request = &OpenLiveShiftRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "OpenLiveShift", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenLiveShiftResponse creates a response to parse from OpenLiveShift response
func CreateOpenLiveShiftResponse() (response *OpenLiveShiftResponse) {
	response = &OpenLiveShiftResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
