package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KickLiveMessageGroupUser invokes the live.KickLiveMessageGroupUser API synchronously
func (client *Client) KickLiveMessageGroupUser(request *KickLiveMessageGroupUserRequest) (response *KickLiveMessageGroupUserResponse, err error) {
	response = CreateKickLiveMessageGroupUserResponse()
	err = client.DoAction(request, response)
	return
}

// KickLiveMessageGroupUserWithChan invokes the live.KickLiveMessageGroupUser API asynchronously
func (client *Client) KickLiveMessageGroupUserWithChan(request *KickLiveMessageGroupUserRequest) (<-chan *KickLiveMessageGroupUserResponse, <-chan error) {
	responseChan := make(chan *KickLiveMessageGroupUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KickLiveMessageGroupUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KickLiveMessageGroupUserWithCallback invokes the live.KickLiveMessageGroupUser API asynchronously
func (client *Client) KickLiveMessageGroupUserWithCallback(request *KickLiveMessageGroupUserRequest, callback func(response *KickLiveMessageGroupUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KickLiveMessageGroupUserResponse
		var err error
		defer close(result)
		response, err = client.KickLiveMessageGroupUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KickLiveMessageGroupUserRequest is the request struct for api KickLiveMessageGroupUser
type KickLiveMessageGroupUserRequest struct {
	*requests.RpcRequest
	GroupId     string `position:"Query" name:"GroupId"`
	DataCenter  string `position:"Query" name:"DataCenter"`
	KickoffUser string `position:"Query" name:"KickoffUser"`
	AppId       string `position:"Query" name:"AppId"`
}

// KickLiveMessageGroupUserResponse is the response struct for api KickLiveMessageGroupUser
type KickLiveMessageGroupUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateKickLiveMessageGroupUserRequest creates a request to invoke KickLiveMessageGroupUser API
func CreateKickLiveMessageGroupUserRequest() (request *KickLiveMessageGroupUserRequest) {
	request = &KickLiveMessageGroupUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "KickLiveMessageGroupUser", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateKickLiveMessageGroupUserResponse creates a response to parse from KickLiveMessageGroupUser response
func CreateKickLiveMessageGroupUserResponse() (response *KickLiveMessageGroupUserResponse) {
	response = &KickLiveMessageGroupUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
