package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamTranscodeMetricData invokes the live.DescribeLiveStreamTranscodeMetricData API synchronously
func (client *Client) DescribeLiveStreamTranscodeMetricData(request *DescribeLiveStreamTranscodeMetricDataRequest) (response *DescribeLiveStreamTranscodeMetricDataResponse, err error) {
	response = CreateDescribeLiveStreamTranscodeMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamTranscodeMetricDataWithChan invokes the live.DescribeLiveStreamTranscodeMetricData API asynchronously
func (client *Client) DescribeLiveStreamTranscodeMetricDataWithChan(request *DescribeLiveStreamTranscodeMetricDataRequest) (<-chan *DescribeLiveStreamTranscodeMetricDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamTranscodeMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamTranscodeMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamTranscodeMetricDataWithCallback invokes the live.DescribeLiveStreamTranscodeMetricData API asynchronously
func (client *Client) DescribeLiveStreamTranscodeMetricDataWithCallback(request *DescribeLiveStreamTranscodeMetricDataRequest, callback func(response *DescribeLiveStreamTranscodeMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamTranscodeMetricDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamTranscodeMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamTranscodeMetricDataRequest is the request struct for api DescribeLiveStreamTranscodeMetricData
type DescribeLiveStreamTranscodeMetricDataRequest struct {
	*requests.RpcRequest
	NextPageToken string           `position:"Query" name:"NextPageToken"`
	StartTime     string           `position:"Query" name:"StartTime"`
	AppName       string           `position:"Query" name:"AppName"`
	StreamName    string           `position:"Query" name:"StreamName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	EndTime       string           `position:"Query" name:"EndTime"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamTranscodeMetricDataResponse is the response struct for api DescribeLiveStreamTranscodeMetricData
type DescribeLiveStreamTranscodeMetricDataResponse struct {
	*responses.BaseResponse
	DomainName       string                                                  `json:"DomainName" xml:"DomainName"`
	EndTime          string                                                  `json:"EndTime" xml:"EndTime"`
	NextPageToken    string                                                  `json:"NextPageToken" xml:"NextPageToken"`
	PageSize         int                                                     `json:"PageSize" xml:"PageSize"`
	RequestId        string                                                  `json:"RequestId" xml:"RequestId"`
	StartTime        string                                                  `json:"StartTime" xml:"StartTime"`
	StreamDetailData StreamDetailDataInDescribeLiveStreamTranscodeMetricData `json:"StreamDetailData" xml:"StreamDetailData"`
}

// CreateDescribeLiveStreamTranscodeMetricDataRequest creates a request to invoke DescribeLiveStreamTranscodeMetricData API
func CreateDescribeLiveStreamTranscodeMetricDataRequest() (request *DescribeLiveStreamTranscodeMetricDataRequest) {
	request = &DescribeLiveStreamTranscodeMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamTranscodeMetricData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamTranscodeMetricDataResponse creates a response to parse from DescribeLiveStreamTranscodeMetricData response
func CreateDescribeLiveStreamTranscodeMetricDataResponse() (response *DescribeLiveStreamTranscodeMetricDataResponse) {
	response = &DescribeLiveStreamTranscodeMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
