package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveMessageGroupBand invokes the live.DescribeLiveMessageGroupBand API synchronously
func (client *Client) DescribeLiveMessageGroupBand(request *DescribeLiveMessageGroupBandRequest) (response *DescribeLiveMessageGroupBandResponse, err error) {
	response = CreateDescribeLiveMessageGroupBandResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveMessageGroupBandWithChan invokes the live.DescribeLiveMessageGroupBand API asynchronously
func (client *Client) DescribeLiveMessageGroupBandWithChan(request *DescribeLiveMessageGroupBandRequest) (<-chan *DescribeLiveMessageGroupBandResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveMessageGroupBandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveMessageGroupBand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveMessageGroupBandWithCallback invokes the live.DescribeLiveMessageGroupBand API asynchronously
func (client *Client) DescribeLiveMessageGroupBandWithCallback(request *DescribeLiveMessageGroupBandRequest, callback func(response *DescribeLiveMessageGroupBandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveMessageGroupBandResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveMessageGroupBand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveMessageGroupBandRequest is the request struct for api DescribeLiveMessageGroupBand
type DescribeLiveMessageGroupBandRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	DataCenter string `position:"Query" name:"DataCenter"`
	AppId      string `position:"Query" name:"AppId"`
}

// DescribeLiveMessageGroupBandResponse is the response struct for api DescribeLiveMessageGroupBand
type DescribeLiveMessageGroupBandResponse struct {
	*responses.BaseResponse
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	GroupId          string   `json:"GroupId" xml:"GroupId"`
	IsbannedAll      bool     `json:"IsbannedAll" xml:"IsbannedAll"`
	BannedUserList   []string `json:"BannedUserList" xml:"BannedUserList"`
	UnbannedUserList []string `json:"UnbannedUserList" xml:"UnbannedUserList"`
}

// CreateDescribeLiveMessageGroupBandRequest creates a request to invoke DescribeLiveMessageGroupBand API
func CreateDescribeLiveMessageGroupBandRequest() (request *DescribeLiveMessageGroupBandRequest) {
	request = &DescribeLiveMessageGroupBandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveMessageGroupBand", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveMessageGroupBandResponse creates a response to parse from DescribeLiveMessageGroupBand response
func CreateDescribeLiveMessageGroupBandResponse() (response *DescribeLiveMessageGroupBandResponse) {
	response = &DescribeLiveMessageGroupBandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
