package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveCdnDiagnoseInfo invokes the live.DescribeLiveCdnDiagnoseInfo API synchronously
func (client *Client) DescribeLiveCdnDiagnoseInfo(request *DescribeLiveCdnDiagnoseInfoRequest) (response *DescribeLiveCdnDiagnoseInfoResponse, err error) {
	response = CreateDescribeLiveCdnDiagnoseInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveCdnDiagnoseInfoWithChan invokes the live.DescribeLiveCdnDiagnoseInfo API asynchronously
func (client *Client) DescribeLiveCdnDiagnoseInfoWithChan(request *DescribeLiveCdnDiagnoseInfoRequest) (<-chan *DescribeLiveCdnDiagnoseInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveCdnDiagnoseInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveCdnDiagnoseInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveCdnDiagnoseInfoWithCallback invokes the live.DescribeLiveCdnDiagnoseInfo API asynchronously
func (client *Client) DescribeLiveCdnDiagnoseInfoWithCallback(request *DescribeLiveCdnDiagnoseInfoRequest, callback func(response *DescribeLiveCdnDiagnoseInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveCdnDiagnoseInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveCdnDiagnoseInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveCdnDiagnoseInfoRequest is the request struct for api DescribeLiveCdnDiagnoseInfo
type DescribeLiveCdnDiagnoseInfoRequest struct {
	*requests.RpcRequest
	IntervalType  string           `position:"Query" name:"intervalType"`
	StreamSuffix  string           `position:"Query" name:"streamSuffix"`
	StartTime     requests.Integer `position:"Query" name:"startTime"`
	RequestType   string           `position:"Query" name:"requestType"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	StreamName    string           `position:"Query" name:"streamName"`
	App           string           `position:"Query" name:"app"`
	Phase         requests.Integer `position:"Query" name:"phase"`
	EndTime       requests.Integer `position:"Query" name:"endTime"`
	Domain        string           `position:"Query" name:"domain"`
}

// DescribeLiveCdnDiagnoseInfoResponse is the response struct for api DescribeLiveCdnDiagnoseInfo
type DescribeLiveCdnDiagnoseInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeLiveCdnDiagnoseInfoRequest creates a request to invoke DescribeLiveCdnDiagnoseInfo API
func CreateDescribeLiveCdnDiagnoseInfoRequest() (request *DescribeLiveCdnDiagnoseInfoRequest) {
	request = &DescribeLiveCdnDiagnoseInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveCdnDiagnoseInfo", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveCdnDiagnoseInfoResponse creates a response to parse from DescribeLiveCdnDiagnoseInfo response
func CreateDescribeLiveCdnDiagnoseInfoResponse() (response *DescribeLiveCdnDiagnoseInfoResponse) {
	response = &DescribeLiveCdnDiagnoseInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
