package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitGatewayTupleOrder invokes the linkwan.SubmitGatewayTupleOrder API synchronously
func (client *Client) SubmitGatewayTupleOrder(request *SubmitGatewayTupleOrderRequest) (response *SubmitGatewayTupleOrderResponse, err error) {
	response = CreateSubmitGatewayTupleOrderResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitGatewayTupleOrderWithChan invokes the linkwan.SubmitGatewayTupleOrder API asynchronously
func (client *Client) SubmitGatewayTupleOrderWithChan(request *SubmitGatewayTupleOrderRequest) (<-chan *SubmitGatewayTupleOrderResponse, <-chan error) {
	responseChan := make(chan *SubmitGatewayTupleOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitGatewayTupleOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitGatewayTupleOrderWithCallback invokes the linkwan.SubmitGatewayTupleOrder API asynchronously
func (client *Client) SubmitGatewayTupleOrderWithCallback(request *SubmitGatewayTupleOrderRequest, callback func(response *SubmitGatewayTupleOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitGatewayTupleOrderResponse
		var err error
		defer close(result)
		response, err = client.SubmitGatewayTupleOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitGatewayTupleOrderRequest is the request struct for api SubmitGatewayTupleOrder
type SubmitGatewayTupleOrderRequest struct {
	*requests.RpcRequest
	TupleType     string           `position:"Query" name:"TupleType"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	RequiredCount requests.Integer `position:"Query" name:"RequiredCount"`
}

// SubmitGatewayTupleOrderResponse is the response struct for api SubmitGatewayTupleOrder
type SubmitGatewayTupleOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateSubmitGatewayTupleOrderRequest creates a request to invoke SubmitGatewayTupleOrder API
func CreateSubmitGatewayTupleOrderRequest() (request *SubmitGatewayTupleOrderRequest) {
	request = &SubmitGatewayTupleOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "SubmitGatewayTupleOrder", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitGatewayTupleOrderResponse creates a response to parse from SubmitGatewayTupleOrder response
func CreateSubmitGatewayTupleOrderResponse() (response *SubmitGatewayTupleOrderResponse) {
	response = &SubmitGatewayTupleOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
