package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTimeTemplateDetail invokes the linkvisual.QueryTimeTemplateDetail API synchronously
func (client *Client) QueryTimeTemplateDetail(request *QueryTimeTemplateDetailRequest) (response *QueryTimeTemplateDetailResponse, err error) {
	response = CreateQueryTimeTemplateDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTimeTemplateDetailWithChan invokes the linkvisual.QueryTimeTemplateDetail API asynchronously
func (client *Client) QueryTimeTemplateDetailWithChan(request *QueryTimeTemplateDetailRequest) (<-chan *QueryTimeTemplateDetailResponse, <-chan error) {
	responseChan := make(chan *QueryTimeTemplateDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTimeTemplateDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTimeTemplateDetailWithCallback invokes the linkvisual.QueryTimeTemplateDetail API asynchronously
func (client *Client) QueryTimeTemplateDetailWithCallback(request *QueryTimeTemplateDetailRequest, callback func(response *QueryTimeTemplateDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTimeTemplateDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryTimeTemplateDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTimeTemplateDetailRequest is the request struct for api QueryTimeTemplateDetail
type QueryTimeTemplateDetailRequest struct {
	*requests.RpcRequest
	TemplateId  string `position:"Query" name:"TemplateId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// QueryTimeTemplateDetailResponse is the response struct for api QueryTimeTemplateDetail
type QueryTimeTemplateDetailResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryTimeTemplateDetailRequest creates a request to invoke QueryTimeTemplateDetail API
func CreateQueryTimeTemplateDetailRequest() (request *QueryTimeTemplateDetailRequest) {
	request = &QueryTimeTemplateDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryTimeTemplateDetail", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTimeTemplateDetailResponse creates a response to parse from QueryTimeTemplateDetail response
func CreateQueryTimeTemplateDetailResponse() (response *QueryTimeTemplateDetailResponse) {
	response = &QueryTimeTemplateDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
