package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceUserGroup invokes the linkvisual.QueryFaceUserGroup API synchronously
func (client *Client) QueryFaceUserGroup(request *QueryFaceUserGroupRequest) (response *QueryFaceUserGroupResponse, err error) {
	response = CreateQueryFaceUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceUserGroupWithChan invokes the linkvisual.QueryFaceUserGroup API asynchronously
func (client *Client) QueryFaceUserGroupWithChan(request *QueryFaceUserGroupRequest) (<-chan *QueryFaceUserGroupResponse, <-chan error) {
	responseChan := make(chan *QueryFaceUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceUserGroupWithCallback invokes the linkvisual.QueryFaceUserGroup API asynchronously
func (client *Client) QueryFaceUserGroupWithCallback(request *QueryFaceUserGroupRequest, callback func(response *QueryFaceUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceUserGroupResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceUserGroupRequest is the request struct for api QueryFaceUserGroup
type QueryFaceUserGroupRequest struct {
	*requests.RpcRequest
	IsolationId string           `position:"Query" name:"IsolationId"`
	UserId      string           `position:"Query" name:"UserId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// QueryFaceUserGroupResponse is the response struct for api QueryFaceUserGroup
type QueryFaceUserGroupResponse struct {
	*responses.BaseResponse
	Code         string                   `json:"Code" xml:"Code"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	Success      bool                     `json:"Success" xml:"Success"`
	Data         DataInQueryFaceUserGroup `json:"Data" xml:"Data"`
}

// CreateQueryFaceUserGroupRequest creates a request to invoke QueryFaceUserGroup API
func CreateQueryFaceUserGroupRequest() (request *QueryFaceUserGroupRequest) {
	request = &QueryFaceUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceUserGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceUserGroupResponse creates a response to parse from QueryFaceUserGroup response
func CreateQueryFaceUserGroupResponse() (response *QueryFaceUserGroupResponse) {
	response = &QueryFaceUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
