package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConnectKmsInstance invokes the kms.ConnectKmsInstance API synchronously
func (client *Client) ConnectKmsInstance(request *ConnectKmsInstanceRequest) (response *ConnectKmsInstanceResponse, err error) {
	response = CreateConnectKmsInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ConnectKmsInstanceWithChan invokes the kms.ConnectKmsInstance API asynchronously
func (client *Client) ConnectKmsInstanceWithChan(request *ConnectKmsInstanceRequest) (<-chan *ConnectKmsInstanceResponse, <-chan error) {
	responseChan := make(chan *ConnectKmsInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConnectKmsInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConnectKmsInstanceWithCallback invokes the kms.ConnectKmsInstance API asynchronously
func (client *Client) ConnectKmsInstanceWithCallback(request *ConnectKmsInstanceRequest, callback func(response *ConnectKmsInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConnectKmsInstanceResponse
		var err error
		defer close(result)
		response, err = client.ConnectKmsInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConnectKmsInstanceRequest is the request struct for api ConnectKmsInstance
type ConnectKmsInstanceRequest struct {
	*requests.RpcRequest
	KmsInstanceId string `position:"Query" name:"KmsInstanceId"`
	VSwitchIds    string `position:"Query" name:"VSwitchIds"`
	KMProvider    string `position:"Query" name:"KMProvider"`
	ZoneIds       string `position:"Query" name:"ZoneIds"`
	VpcId         string `position:"Query" name:"VpcId"`
}

// ConnectKmsInstanceResponse is the response struct for api ConnectKmsInstance
type ConnectKmsInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConnectKmsInstanceRequest creates a request to invoke ConnectKmsInstance API
func CreateConnectKmsInstanceRequest() (request *ConnectKmsInstanceRequest) {
	request = &ConnectKmsInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ConnectKmsInstance", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConnectKmsInstanceResponse creates a response to parse from ConnectKmsInstance response
func CreateConnectKmsInstanceResponse() (response *ConnectKmsInstanceResponse) {
	response = &ConnectKmsInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
