package jarvis_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAttackEvent invokes the jarvis_public.DescribeAttackEvent API synchronously
// api document: https://help.aliyun.com/api/jarvis-public/describeattackevent.html
func (client *Client) DescribeAttackEvent(request *DescribeAttackEventRequest) (response *DescribeAttackEventResponse, err error) {
	response = CreateDescribeAttackEventResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAttackEventWithChan invokes the jarvis_public.DescribeAttackEvent API asynchronously
// api document: https://help.aliyun.com/api/jarvis-public/describeattackevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAttackEventWithChan(request *DescribeAttackEventRequest) (<-chan *DescribeAttackEventResponse, <-chan error) {
	responseChan := make(chan *DescribeAttackEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAttackEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAttackEventWithCallback invokes the jarvis_public.DescribeAttackEvent API asynchronously
// api document: https://help.aliyun.com/api/jarvis-public/describeattackevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAttackEventWithCallback(request *DescribeAttackEventRequest, callback func(response *DescribeAttackEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAttackEventResponse
		var err error
		defer close(result)
		response, err = client.DescribeAttackEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAttackEventRequest is the request struct for api DescribeAttackEvent
type DescribeAttackEventRequest struct {
	*requests.RpcRequest
	SourceIp     string           `position:"Query" name:"SourceIp"`
	ServerIpList string           `position:"Query" name:"ServerIpList"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	Lang         string           `position:"Query" name:"Lang"`
	Region       string           `position:"Query" name:"Region"`
	ProductType  string           `position:"Query" name:"ProductType"`
}

// DescribeAttackEventResponse is the response struct for api DescribeAttackEvent
type DescribeAttackEventResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Module    string  `json:"Module" xml:"Module"`
	EventList []Event `json:"EventList" xml:"EventList"`
}

// CreateDescribeAttackEventRequest creates a request to invoke DescribeAttackEvent API
func CreateDescribeAttackEventRequest() (request *DescribeAttackEventRequest) {
	request = &DescribeAttackEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis-public", "2018-06-21", "DescribeAttackEvent", "jarvis-public", "openAPI")
	return
}

// CreateDescribeAttackEventResponse creates a response to parse from DescribeAttackEvent response
func CreateDescribeAttackEventResponse() (response *DescribeAttackEventResponse) {
	response = &DescribeAttackEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
