package iqs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRestaurants invokes the iqs.QueryRestaurants API synchronously
func (client *Client) QueryRestaurants(request *QueryRestaurantsRequest) (response *QueryRestaurantsResponse, err error) {
	response = CreateQueryRestaurantsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRestaurantsWithChan invokes the iqs.QueryRestaurants API asynchronously
func (client *Client) QueryRestaurantsWithChan(request *QueryRestaurantsRequest) (<-chan *QueryRestaurantsResponse, <-chan error) {
	responseChan := make(chan *QueryRestaurantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRestaurants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRestaurantsWithCallback invokes the iqs.QueryRestaurants API asynchronously
func (client *Client) QueryRestaurantsWithCallback(request *QueryRestaurantsRequest, callback func(response *QueryRestaurantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRestaurantsResponse
		var err error
		defer close(result)
		response, err = client.QueryRestaurants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRestaurantsRequest is the request struct for api QueryRestaurants
type QueryRestaurantsRequest struct {
	*requests.RoaRequest
}

// QueryRestaurantsResponse is the response struct for api QueryRestaurants
type QueryRestaurantsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"requestId" xml:"requestId"`
	QueryResult QueryResult `json:"queryResult" xml:"queryResult"`
}

// CreateQueryRestaurantsRequest creates a request to invoke QueryRestaurants API
func CreateQueryRestaurantsRequest() (request *QueryRestaurantsRequest) {
	request = &QueryRestaurantsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("IQS", "2024-07-12", "QueryRestaurants", "/amap-function-call-agent/iqs-agent-service/v1/nl/restaurants", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRestaurantsResponse creates a response to parse from QueryRestaurants response
func CreateQueryRestaurantsResponse() (response *QueryRestaurantsResponse) {
	response = &QueryRestaurantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
