package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSoundCodeSchedule invokes the iot.UpdateSoundCodeSchedule API synchronously
func (client *Client) UpdateSoundCodeSchedule(request *UpdateSoundCodeScheduleRequest) (response *UpdateSoundCodeScheduleResponse, err error) {
	response = CreateUpdateSoundCodeScheduleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSoundCodeScheduleWithChan invokes the iot.UpdateSoundCodeSchedule API asynchronously
func (client *Client) UpdateSoundCodeScheduleWithChan(request *UpdateSoundCodeScheduleRequest) (<-chan *UpdateSoundCodeScheduleResponse, <-chan error) {
	responseChan := make(chan *UpdateSoundCodeScheduleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSoundCodeSchedule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSoundCodeScheduleWithCallback invokes the iot.UpdateSoundCodeSchedule API asynchronously
func (client *Client) UpdateSoundCodeScheduleWithCallback(request *UpdateSoundCodeScheduleRequest, callback func(response *UpdateSoundCodeScheduleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSoundCodeScheduleResponse
		var err error
		defer close(result)
		response, err = client.UpdateSoundCodeSchedule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSoundCodeScheduleRequest is the request struct for api UpdateSoundCodeSchedule
type UpdateSoundCodeScheduleRequest struct {
	*requests.RpcRequest
	ScheduleCode  string `position:"Body" name:"ScheduleCode"`
	Description   string `position:"Body" name:"Description"`
	StartTime     string `position:"Body" name:"StartTime"`
	StartDate     string `position:"Body" name:"StartDate"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	EndTime       string `position:"Body" name:"EndTime"`
	EndDate       string `position:"Body" name:"EndDate"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	Name          string `position:"Body" name:"Name"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	Status        string `position:"Body" name:"Status"`
}

// UpdateSoundCodeScheduleResponse is the response struct for api UpdateSoundCodeSchedule
type UpdateSoundCodeScheduleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateSoundCodeScheduleRequest creates a request to invoke UpdateSoundCodeSchedule API
func CreateUpdateSoundCodeScheduleRequest() (request *UpdateSoundCodeScheduleRequest) {
	request = &UpdateSoundCodeScheduleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateSoundCodeSchedule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSoundCodeScheduleResponse creates a response to parse from UpdateSoundCodeSchedule response
func CreateUpdateSoundCodeScheduleResponse() (response *UpdateSoundCodeScheduleResponse) {
	response = &UpdateSoundCodeScheduleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
