package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateOTAJob invokes the iot.UpdateOTAJob API synchronously
func (client *Client) UpdateOTAJob(request *UpdateOTAJobRequest) (response *UpdateOTAJobResponse, err error) {
	response = CreateUpdateOTAJobResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateOTAJobWithChan invokes the iot.UpdateOTAJob API asynchronously
func (client *Client) UpdateOTAJobWithChan(request *UpdateOTAJobRequest) (<-chan *UpdateOTAJobResponse, <-chan error) {
	responseChan := make(chan *UpdateOTAJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateOTAJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateOTAJobWithCallback invokes the iot.UpdateOTAJob API asynchronously
func (client *Client) UpdateOTAJobWithCallback(request *UpdateOTAJobRequest, callback func(response *UpdateOTAJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateOTAJobResponse
		var err error
		defer close(result)
		response, err = client.UpdateOTAJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateOTAJobRequest is the request struct for api UpdateOTAJob
type UpdateOTAJobRequest struct {
	*requests.RpcRequest
	RealTenantId            string              `position:"Query" name:"RealTenantId"`
	IncrementFactor         string              `position:"Query" name:"IncrementFactor"`
	BaseRatePerMinute       requests.Integer    `position:"Query" name:"BaseRatePerMinute"`
	UpgradeType             string              `position:"Query" name:"UpgradeType"`
	TimeoutInMinutes        requests.Integer    `position:"Query" name:"TimeoutInMinutes"`
	RealTripartiteKey       string              `position:"Query" name:"RealTripartiteKey"`
	JobId                   string              `position:"Query" name:"JobId"`
	NumberOfSucceedDevices  requests.Integer    `position:"Query" name:"NumberOfSucceedDevices"`
	IotInstanceId           string              `position:"Query" name:"IotInstanceId"`
	SrcVersionList          *[]string           `position:"Query" name:"SrcVersionList"  type:"Repeated"`
	TargetSelection         string              `position:"Query" name:"TargetSelection"`
	Tags                    *[]UpdateOTAJobTags `position:"Query" name:"Tags"  type:"Repeated"`
	NumberOfNotifiedDevices requests.Integer    `position:"Query" name:"NumberOfNotifiedDevices"`
	ApiProduct              string              `position:"Body" name:"ApiProduct"`
	ApiRevision             string              `position:"Body" name:"ApiRevision"`
	MaximumPerMinute        requests.Integer    `position:"Query" name:"MaximumPerMinute"`
}

// UpdateOTAJobTags is a repeated param struct in UpdateOTAJobRequest
type UpdateOTAJobTags struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// UpdateOTAJobResponse is the response struct for api UpdateOTAJob
type UpdateOTAJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateOTAJobRequest creates a request to invoke UpdateOTAJob API
func CreateUpdateOTAJobRequest() (request *UpdateOTAJobRequest) {
	request = &UpdateOTAJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateOTAJob", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateOTAJobResponse creates a response to parse from UpdateOTAJob response
func CreateUpdateOTAJobResponse() (response *UpdateOTAJobResponse) {
	response = &UpdateOTAJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
