package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSharePromotionSpeechModel invokes the iot.CreateSharePromotionSpeechModel API synchronously
func (client *Client) CreateSharePromotionSpeechModel(request *CreateSharePromotionSpeechModelRequest) (response *CreateSharePromotionSpeechModelResponse, err error) {
	response = CreateCreateSharePromotionSpeechModelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSharePromotionSpeechModelWithChan invokes the iot.CreateSharePromotionSpeechModel API asynchronously
func (client *Client) CreateSharePromotionSpeechModelWithChan(request *CreateSharePromotionSpeechModelRequest) (<-chan *CreateSharePromotionSpeechModelResponse, <-chan error) {
	responseChan := make(chan *CreateSharePromotionSpeechModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSharePromotionSpeechModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSharePromotionSpeechModelWithCallback invokes the iot.CreateSharePromotionSpeechModel API asynchronously
func (client *Client) CreateSharePromotionSpeechModelWithCallback(request *CreateSharePromotionSpeechModelRequest, callback func(response *CreateSharePromotionSpeechModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSharePromotionSpeechModelResponse
		var err error
		defer close(result)
		response, err = client.CreateSharePromotionSpeechModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSharePromotionSpeechModelRequest is the request struct for api CreateSharePromotionSpeechModel
type CreateSharePromotionSpeechModelRequest struct {
	*requests.RpcRequest
	Voice                    string           `position:"Body" name:"Voice"`
	SharePromotionActivityId string           `position:"Body" name:"SharePromotionActivityId"`
	AudioFormat              string           `position:"Body" name:"AudioFormat"`
	IotInstanceId            string           `position:"Body" name:"IotInstanceId"`
	Text                     string           `position:"Body" name:"Text"`
	SpeechModelType          string           `position:"Body" name:"SpeechModelType"`
	ShareTaskCode            string           `position:"Body" name:"ShareTaskCode"`
	Volume                   requests.Integer `position:"Body" name:"Volume"`
	BizCode                  string           `position:"Body" name:"BizCode"`
	ApiProduct               string           `position:"Body" name:"ApiProduct"`
	ApiRevision              string           `position:"Body" name:"ApiRevision"`
	SpeechRate               requests.Integer `position:"Body" name:"SpeechRate"`
}

// CreateSharePromotionSpeechModelResponse is the response struct for api CreateSharePromotionSpeechModel
type CreateSharePromotionSpeechModelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateCreateSharePromotionSpeechModelRequest creates a request to invoke CreateSharePromotionSpeechModel API
func CreateCreateSharePromotionSpeechModelRequest() (request *CreateSharePromotionSpeechModelRequest) {
	request = &CreateSharePromotionSpeechModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateSharePromotionSpeechModel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSharePromotionSpeechModelResponse creates a response to parse from CreateSharePromotionSpeechModel response
func CreateCreateSharePromotionSpeechModelResponse() (response *CreateSharePromotionSpeechModelResponse) {
	response = &CreateSharePromotionSpeechModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
