package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPowerStation invokes the iot.AddPowerStation API synchronously
func (client *Client) AddPowerStation(request *AddPowerStationRequest) (response *AddPowerStationResponse, err error) {
	response = CreateAddPowerStationResponse()
	err = client.DoAction(request, response)
	return
}

// AddPowerStationWithChan invokes the iot.AddPowerStation API asynchronously
func (client *Client) AddPowerStationWithChan(request *AddPowerStationRequest) (<-chan *AddPowerStationResponse, <-chan error) {
	responseChan := make(chan *AddPowerStationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPowerStation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPowerStationWithCallback invokes the iot.AddPowerStation API asynchronously
func (client *Client) AddPowerStationWithCallback(request *AddPowerStationRequest, callback func(response *AddPowerStationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPowerStationResponse
		var err error
		defer close(result)
		response, err = client.AddPowerStation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPowerStationRequest is the request struct for api AddPowerStation
type AddPowerStationRequest struct {
	*requests.RpcRequest
	RatedPower           requests.Integer `position:"Query" name:"RatedPower"`
	Description          string           `position:"Query" name:"Description"`
	IotInstanceId        string           `position:"Query" name:"IotInstanceId"`
	AlgorithmInstanceUid string           `position:"Query" name:"AlgorithmInstanceUid"`
	PowerStationName     string           `position:"Query" name:"PowerStationName"`
	ApiProduct           string           `position:"Body" name:"ApiProduct"`
	ApiRevision          string           `position:"Body" name:"ApiRevision"`
}

// AddPowerStationResponse is the response struct for api AddPowerStation
type AddPowerStationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateAddPowerStationRequest creates a request to invoke AddPowerStation API
func CreateAddPowerStationRequest() (request *AddPowerStationRequest) {
	request = &AddPowerStationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "AddPowerStation", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPowerStationResponse creates a response to parse from AddPowerStation response
func CreateAddPowerStationResponse() (response *AddPowerStationResponse) {
	response = &AddPowerStationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
