package imgsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListImageDbs invokes the imgsearch.ListImageDbs API synchronously
func (client *Client) ListImageDbs(request *ListImageDbsRequest) (response *ListImageDbsResponse, err error) {
	response = CreateListImageDbsResponse()
	err = client.DoAction(request, response)
	return
}

// ListImageDbsWithChan invokes the imgsearch.ListImageDbs API asynchronously
func (client *Client) ListImageDbsWithChan(request *ListImageDbsRequest) (<-chan *ListImageDbsResponse, <-chan error) {
	responseChan := make(chan *ListImageDbsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListImageDbs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListImageDbsWithCallback invokes the imgsearch.ListImageDbs API asynchronously
func (client *Client) ListImageDbsWithCallback(request *ListImageDbsRequest, callback func(response *ListImageDbsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListImageDbsResponse
		var err error
		defer close(result)
		response, err = client.ListImageDbs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListImageDbsRequest is the request struct for api ListImageDbs
type ListImageDbsRequest struct {
	*requests.RpcRequest
}

// ListImageDbsResponse is the response struct for api ListImageDbs
type ListImageDbsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListImageDbsRequest creates a request to invoke ListImageDbs API
func CreateListImageDbsRequest() (request *ListImageDbsRequest) {
	request = &ListImageDbsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imgsearch", "2020-03-20", "ListImageDbs", "", "")
	request.Method = requests.POST
	return
}

// CreateListImageDbsResponse creates a response to parse from ListImageDbs response
func CreateListImageDbsResponse() (response *ListImageDbsResponse) {
	response = &ListImageDbsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
