package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TargetVolumeSegment invokes the imageprocess.TargetVolumeSegment API synchronously
func (client *Client) TargetVolumeSegment(request *TargetVolumeSegmentRequest) (response *TargetVolumeSegmentResponse, err error) {
	response = CreateTargetVolumeSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// TargetVolumeSegmentWithChan invokes the imageprocess.TargetVolumeSegment API asynchronously
func (client *Client) TargetVolumeSegmentWithChan(request *TargetVolumeSegmentRequest) (<-chan *TargetVolumeSegmentResponse, <-chan error) {
	responseChan := make(chan *TargetVolumeSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TargetVolumeSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TargetVolumeSegmentWithCallback invokes the imageprocess.TargetVolumeSegment API asynchronously
func (client *Client) TargetVolumeSegmentWithCallback(request *TargetVolumeSegmentRequest, callback func(response *TargetVolumeSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TargetVolumeSegmentResponse
		var err error
		defer close(result)
		response, err = client.TargetVolumeSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TargetVolumeSegmentRequest is the request struct for api TargetVolumeSegment
type TargetVolumeSegmentRequest struct {
	*requests.RpcRequest
	CancerType       string                        `position:"Body" name:"CancerType"`
	OrgName          string                        `position:"Body" name:"OrgName"`
	TargetVolumeType string                        `position:"Body" name:"TargetVolumeType"`
	DataFormat       string                        `position:"Body" name:"DataFormat"`
	URLList          *[]TargetVolumeSegmentURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId            string                        `position:"Body" name:"OrgId"`
	Async            requests.Boolean              `position:"Body" name:"Async"`
}

// TargetVolumeSegmentURLList is a repeated param struct in TargetVolumeSegmentRequest
type TargetVolumeSegmentURLList struct {
	URL string `name:"URL"`
}

// TargetVolumeSegmentResponse is the response struct for api TargetVolumeSegment
type TargetVolumeSegmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTargetVolumeSegmentRequest creates a request to invoke TargetVolumeSegment API
func CreateTargetVolumeSegmentRequest() (request *TargetVolumeSegmentRequest) {
	request = &TargetVolumeSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "TargetVolumeSegment", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTargetVolumeSegmentResponse creates a response to parse from TargetVolumeSegment response
func CreateTargetVolumeSegmentResponse() (response *TargetVolumeSegmentResponse) {
	response = &TargetVolumeSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
