package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentOAR invokes the imageprocess.SegmentOAR API synchronously
func (client *Client) SegmentOAR(request *SegmentOARRequest) (response *SegmentOARResponse, err error) {
	response = CreateSegmentOARResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentOARWithChan invokes the imageprocess.SegmentOAR API asynchronously
func (client *Client) SegmentOARWithChan(request *SegmentOARRequest) (<-chan *SegmentOARResponse, <-chan error) {
	responseChan := make(chan *SegmentOARResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentOAR(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentOARWithCallback invokes the imageprocess.SegmentOAR API asynchronously
func (client *Client) SegmentOARWithCallback(request *SegmentOARRequest, callback func(response *SegmentOARResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentOARResponse
		var err error
		defer close(result)
		response, err = client.SegmentOAR(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentOARRequest is the request struct for api SegmentOAR
type SegmentOARRequest struct {
	*requests.RpcRequest
	OrgName    string               `position:"Body" name:"OrgName"`
	BodyPart   string               `position:"Body" name:"BodyPart"`
	DataFormat string               `position:"Body" name:"DataFormat"`
	URLList    *[]SegmentOARURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId      string               `position:"Body" name:"OrgId"`
	Async      requests.Boolean     `position:"Body" name:"Async"`
	Contrast   requests.Boolean     `position:"Body" name:"Contrast"`
	MaskList   *[]string            `position:"Body" name:"MaskList"  type:"Repeated"`
}

// SegmentOARURLList is a repeated param struct in SegmentOARRequest
type SegmentOARURLList struct {
	URL string `name:"URL"`
}

// SegmentOARResponse is the response struct for api SegmentOAR
type SegmentOARResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentOARRequest creates a request to invoke SegmentOAR API
func CreateSegmentOARRequest() (request *SegmentOARRequest) {
	request = &SegmentOARRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "SegmentOAR", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentOARResponse creates a response to parse from SegmentOAR response
func CreateSegmentOARResponse() (response *SegmentOARResponse) {
	response = &SegmentOARResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
