package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectPanc invokes the imageprocess.DetectPanc API synchronously
func (client *Client) DetectPanc(request *DetectPancRequest) (response *DetectPancResponse, err error) {
	response = CreateDetectPancResponse()
	err = client.DoAction(request, response)
	return
}

// DetectPancWithChan invokes the imageprocess.DetectPanc API asynchronously
func (client *Client) DetectPancWithChan(request *DetectPancRequest) (<-chan *DetectPancResponse, <-chan error) {
	responseChan := make(chan *DetectPancResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectPanc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectPancWithCallback invokes the imageprocess.DetectPanc API asynchronously
func (client *Client) DetectPancWithCallback(request *DetectPancRequest, callback func(response *DetectPancResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectPancResponse
		var err error
		defer close(result)
		response, err = client.DetectPanc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectPancRequest is the request struct for api DetectPanc
type DetectPancRequest struct {
	*requests.RpcRequest
	DataSourceType string               `position:"Body" name:"DataSourceType"`
	URLList        *[]DetectPancURLList `position:"Body" name:"URLList"  type:"Repeated"`
	Async          requests.Boolean     `position:"Body" name:"Async"`
}

// DetectPancURLList is a repeated param struct in DetectPancRequest
type DetectPancURLList struct {
	URL string `name:"URL"`
}

// DetectPancResponse is the response struct for api DetectPanc
type DetectPancResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectPancRequest creates a request to invoke DetectPanc API
func CreateDetectPancRequest() (request *DetectPancRequest) {
	request = &DetectPancRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectPanc", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectPancResponse creates a response to parse from DetectPanc response
func CreateDetectPancResponse() (response *DetectPancResponse) {
	response = &DetectPancResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
