package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssessSharpness invokes the imageenhan.AssessSharpness API synchronously
func (client *Client) AssessSharpness(request *AssessSharpnessRequest) (response *AssessSharpnessResponse, err error) {
	response = CreateAssessSharpnessResponse()
	err = client.DoAction(request, response)
	return
}

// AssessSharpnessWithChan invokes the imageenhan.AssessSharpness API asynchronously
func (client *Client) AssessSharpnessWithChan(request *AssessSharpnessRequest) (<-chan *AssessSharpnessResponse, <-chan error) {
	responseChan := make(chan *AssessSharpnessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssessSharpness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssessSharpnessWithCallback invokes the imageenhan.AssessSharpness API asynchronously
func (client *Client) AssessSharpnessWithCallback(request *AssessSharpnessRequest, callback func(response *AssessSharpnessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssessSharpnessResponse
		var err error
		defer close(result)
		response, err = client.AssessSharpness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssessSharpnessRequest is the request struct for api AssessSharpness
type AssessSharpnessRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// AssessSharpnessResponse is the response struct for api AssessSharpness
type AssessSharpnessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAssessSharpnessRequest creates a request to invoke AssessSharpness API
func CreateAssessSharpnessRequest() (request *AssessSharpnessRequest) {
	request = &AssessSharpnessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "AssessSharpness", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssessSharpnessResponse creates a response to parse from AssessSharpness response
func CreateAssessSharpnessResponse() (response *AssessSharpnessResponse) {
	response = &AssessSharpnessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
