package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSignedUrl invokes the idrsservice.GetSignedUrl API synchronously
func (client *Client) GetSignedUrl(request *GetSignedUrlRequest) (response *GetSignedUrlResponse, err error) {
	response = CreateGetSignedUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetSignedUrlWithChan invokes the idrsservice.GetSignedUrl API asynchronously
func (client *Client) GetSignedUrlWithChan(request *GetSignedUrlRequest) (<-chan *GetSignedUrlResponse, <-chan error) {
	responseChan := make(chan *GetSignedUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSignedUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSignedUrlWithCallback invokes the idrsservice.GetSignedUrl API asynchronously
func (client *Client) GetSignedUrlWithCallback(request *GetSignedUrlRequest, callback func(response *GetSignedUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSignedUrlResponse
		var err error
		defer close(result)
		response, err = client.GetSignedUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSignedUrlRequest is the request struct for api GetSignedUrl
type GetSignedUrlRequest struct {
	*requests.RpcRequest
	FileUrl string `position:"Body" name:"FileUrl"`
}

// GetSignedUrlResponse is the response struct for api GetSignedUrl
type GetSignedUrlResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetSignedUrlRequest creates a request to invoke GetSignedUrl API
func CreateGetSignedUrlRequest() (request *GetSignedUrlRequest) {
	request = &GetSignedUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "GetSignedUrl", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSignedUrlResponse creates a response to parse from GetSignedUrl response
func CreateGetSignedUrlResponse() (response *GetSignedUrlResponse) {
	response = &GetSignedUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
