package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetModelSignedUrl invokes the idrsservice.GetModelSignedUrl API synchronously
func (client *Client) GetModelSignedUrl(request *GetModelSignedUrlRequest) (response *GetModelSignedUrlResponse, err error) {
	response = CreateGetModelSignedUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetModelSignedUrlWithChan invokes the idrsservice.GetModelSignedUrl API asynchronously
func (client *Client) GetModelSignedUrlWithChan(request *GetModelSignedUrlRequest) (<-chan *GetModelSignedUrlResponse, <-chan error) {
	responseChan := make(chan *GetModelSignedUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetModelSignedUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetModelSignedUrlWithCallback invokes the idrsservice.GetModelSignedUrl API asynchronously
func (client *Client) GetModelSignedUrlWithCallback(request *GetModelSignedUrlRequest, callback func(response *GetModelSignedUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetModelSignedUrlResponse
		var err error
		defer close(result)
		response, err = client.GetModelSignedUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetModelSignedUrlRequest is the request struct for api GetModelSignedUrl
type GetModelSignedUrlRequest struct {
	*requests.RpcRequest
	ModelPath *[]string `position:"Body" name:"ModelPath"  type:"Repeated"`
}

// GetModelSignedUrlResponse is the response struct for api GetModelSignedUrl
type GetModelSignedUrlResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetModelSignedUrlRequest creates a request to invoke GetModelSignedUrl API
func CreateGetModelSignedUrlRequest() (request *GetModelSignedUrlRequest) {
	request = &GetModelSignedUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "GetModelSignedUrl", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetModelSignedUrlResponse creates a response to parse from GetModelSignedUrl response
func CreateGetModelSignedUrlResponse() (response *GetModelSignedUrlResponse) {
	response = &GetModelSignedUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
