package gwlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateListenerAttribute invokes the gwlb.UpdateListenerAttribute API synchronously
func (client *Client) UpdateListenerAttribute(request *UpdateListenerAttributeRequest) (response *UpdateListenerAttributeResponse, err error) {
	response = CreateUpdateListenerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateListenerAttributeWithChan invokes the gwlb.UpdateListenerAttribute API asynchronously
func (client *Client) UpdateListenerAttributeWithChan(request *UpdateListenerAttributeRequest) (<-chan *UpdateListenerAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateListenerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateListenerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateListenerAttributeWithCallback invokes the gwlb.UpdateListenerAttribute API asynchronously
func (client *Client) UpdateListenerAttributeWithCallback(request *UpdateListenerAttributeRequest, callback func(response *UpdateListenerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateListenerAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateListenerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateListenerAttributeRequest is the request struct for api UpdateListenerAttribute
type UpdateListenerAttributeRequest struct {
	*requests.RpcRequest
	ClientToken         string           `position:"Body" name:"ClientToken"`
	ServerGroupId       string           `position:"Body" name:"ServerGroupId"`
	ListenerId          string           `position:"Body" name:"ListenerId"`
	DryRun              requests.Boolean `position:"Body" name:"DryRun"`
	ListenerDescription string           `position:"Body" name:"ListenerDescription"`
}

// UpdateListenerAttributeResponse is the response struct for api UpdateListenerAttribute
type UpdateListenerAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateListenerAttributeRequest creates a request to invoke UpdateListenerAttribute API
func CreateUpdateListenerAttributeRequest() (request *UpdateListenerAttributeRequest) {
	request = &UpdateListenerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Gwlb", "2024-04-15", "UpdateListenerAttribute", "gwlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateListenerAttributeResponse creates a response to parse from UpdateListenerAttribute response
func CreateUpdateListenerAttributeResponse() (response *UpdateListenerAttributeResponse) {
	response = &UpdateListenerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
