package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWaitingSQLInfo invokes the gpdb.DescribeWaitingSQLInfo API synchronously
func (client *Client) DescribeWaitingSQLInfo(request *DescribeWaitingSQLInfoRequest) (response *DescribeWaitingSQLInfoResponse, err error) {
	response = CreateDescribeWaitingSQLInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWaitingSQLInfoWithChan invokes the gpdb.DescribeWaitingSQLInfo API asynchronously
func (client *Client) DescribeWaitingSQLInfoWithChan(request *DescribeWaitingSQLInfoRequest) (<-chan *DescribeWaitingSQLInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeWaitingSQLInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWaitingSQLInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWaitingSQLInfoWithCallback invokes the gpdb.DescribeWaitingSQLInfo API asynchronously
func (client *Client) DescribeWaitingSQLInfoWithCallback(request *DescribeWaitingSQLInfoRequest, callback func(response *DescribeWaitingSQLInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWaitingSQLInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeWaitingSQLInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWaitingSQLInfoRequest is the request struct for api DescribeWaitingSQLInfo
type DescribeWaitingSQLInfoRequest struct {
	*requests.RpcRequest
	PID          string `position:"Query" name:"PID"`
	Database     string `position:"Query" name:"Database"`
	DBInstanceId string `position:"Query" name:"DBInstanceId"`
}

// DescribeWaitingSQLInfoResponse is the response struct for api DescribeWaitingSQLInfo
type DescribeWaitingSQLInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Database  string `json:"Database" xml:"Database"`
	Items     []Item `json:"Items" xml:"Items"`
}

// CreateDescribeWaitingSQLInfoRequest creates a request to invoke DescribeWaitingSQLInfo API
func CreateDescribeWaitingSQLInfoRequest() (request *DescribeWaitingSQLInfoRequest) {
	request = &DescribeWaitingSQLInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeWaitingSQLInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeWaitingSQLInfoResponse creates a response to parse from DescribeWaitingSQLInfo response
func CreateDescribeWaitingSQLInfoResponse() (response *DescribeWaitingSQLInfoResponse) {
	response = &DescribeWaitingSQLInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
