package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceErrorLog invokes the gpdb.DescribeDBInstanceErrorLog API synchronously
func (client *Client) DescribeDBInstanceErrorLog(request *DescribeDBInstanceErrorLogRequest) (response *DescribeDBInstanceErrorLogResponse, err error) {
	response = CreateDescribeDBInstanceErrorLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceErrorLogWithChan invokes the gpdb.DescribeDBInstanceErrorLog API asynchronously
func (client *Client) DescribeDBInstanceErrorLogWithChan(request *DescribeDBInstanceErrorLogRequest) (<-chan *DescribeDBInstanceErrorLogResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceErrorLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceErrorLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceErrorLogWithCallback invokes the gpdb.DescribeDBInstanceErrorLog API asynchronously
func (client *Client) DescribeDBInstanceErrorLogWithCallback(request *DescribeDBInstanceErrorLogRequest, callback func(response *DescribeDBInstanceErrorLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceErrorLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceErrorLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceErrorLogRequest is the request struct for api DescribeDBInstanceErrorLog
type DescribeDBInstanceErrorLogRequest struct {
	*requests.RpcRequest
	Keywords     string           `position:"Query" name:"Keywords"`
	StartTime    string           `position:"Query" name:"StartTime"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	Database     string           `position:"Query" name:"Database"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Host         string           `position:"Query" name:"Host"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	EndTime      string           `position:"Query" name:"EndTime"`
	LogLevel     string           `position:"Query" name:"LogLevel"`
	User         string           `position:"Query" name:"User"`
}

// DescribeDBInstanceErrorLogResponse is the response struct for api DescribeDBInstanceErrorLog
type DescribeDBInstanceErrorLogResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	Items      []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeDBInstanceErrorLogRequest creates a request to invoke DescribeDBInstanceErrorLog API
func CreateDescribeDBInstanceErrorLogRequest() (request *DescribeDBInstanceErrorLogRequest) {
	request = &DescribeDBInstanceErrorLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBInstanceErrorLog", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceErrorLogResponse creates a response to parse from DescribeDBInstanceErrorLog response
func CreateDescribeDBInstanceErrorLogResponse() (response *DescribeDBInstanceErrorLogResponse) {
	response = &DescribeDBInstanceErrorLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
