package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterNode invokes the gpdb.DescribeDBClusterNode API synchronously
func (client *Client) DescribeDBClusterNode(request *DescribeDBClusterNodeRequest) (response *DescribeDBClusterNodeResponse, err error) {
	response = CreateDescribeDBClusterNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterNodeWithChan invokes the gpdb.DescribeDBClusterNode API asynchronously
func (client *Client) DescribeDBClusterNodeWithChan(request *DescribeDBClusterNodeRequest) (<-chan *DescribeDBClusterNodeResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterNodeWithCallback invokes the gpdb.DescribeDBClusterNode API asynchronously
func (client *Client) DescribeDBClusterNodeWithCallback(request *DescribeDBClusterNodeRequest, callback func(response *DescribeDBClusterNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterNodeResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterNodeRequest is the request struct for api DescribeDBClusterNode
type DescribeDBClusterNodeRequest struct {
	*requests.RpcRequest
	NodeType     string `position:"Query" name:"NodeType"`
	DBInstanceId string `position:"Query" name:"DBInstanceId"`
}

// DescribeDBClusterNodeResponse is the response struct for api DescribeDBClusterNode
type DescribeDBClusterNodeResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
	Nodes       []Node `json:"Nodes" xml:"Nodes"`
}

// CreateDescribeDBClusterNodeRequest creates a request to invoke DescribeDBClusterNode API
func CreateDescribeDBClusterNodeRequest() (request *DescribeDBClusterNodeRequest) {
	request = &DescribeDBClusterNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBClusterNode", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterNodeResponse creates a response to parse from DescribeDBClusterNode response
func CreateDescribeDBClusterNodeResponse() (response *DescribeDBClusterNodeResponse) {
	response = &DescribeDBClusterNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
