package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBInstancePlan invokes the gpdb.CreateDBInstancePlan API synchronously
func (client *Client) CreateDBInstancePlan(request *CreateDBInstancePlanRequest) (response *CreateDBInstancePlanResponse, err error) {
	response = CreateCreateDBInstancePlanResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBInstancePlanWithChan invokes the gpdb.CreateDBInstancePlan API asynchronously
func (client *Client) CreateDBInstancePlanWithChan(request *CreateDBInstancePlanRequest) (<-chan *CreateDBInstancePlanResponse, <-chan error) {
	responseChan := make(chan *CreateDBInstancePlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBInstancePlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBInstancePlanWithCallback invokes the gpdb.CreateDBInstancePlan API asynchronously
func (client *Client) CreateDBInstancePlanWithCallback(request *CreateDBInstancePlanRequest, callback func(response *CreateDBInstancePlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBInstancePlanResponse
		var err error
		defer close(result)
		response, err = client.CreateDBInstancePlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBInstancePlanRequest is the request struct for api CreateDBInstancePlan
type CreateDBInstancePlanRequest struct {
	*requests.RpcRequest
	PlanType         string           `position:"Query" name:"PlanType"`
	PlanStartDate    string           `position:"Query" name:"PlanStartDate"`
	PlanConfig       string           `position:"Query" name:"PlanConfig"`
	PlanName         string           `position:"Query" name:"PlanName"`
	DBInstanceId     string           `position:"Query" name:"DBInstanceId"`
	PlanDesc         string           `position:"Query" name:"PlanDesc"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	PlanEndDate      string           `position:"Query" name:"PlanEndDate"`
	PlanScheduleType string           `position:"Query" name:"PlanScheduleType"`
}

// CreateDBInstancePlanResponse is the response struct for api CreateDBInstancePlan
type CreateDBInstancePlanResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Status       string `json:"Status" xml:"Status"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
	PlanId       string `json:"PlanId" xml:"PlanId"`
}

// CreateCreateDBInstancePlanRequest creates a request to invoke CreateDBInstancePlan API
func CreateCreateDBInstancePlanRequest() (request *CreateDBInstancePlanRequest) {
	request = &CreateDBInstancePlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "CreateDBInstancePlan", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDBInstancePlanResponse creates a response to parse from CreateDBInstancePlan response
func CreateCreateDBInstancePlanResponse() (response *CreateDBInstancePlanResponse) {
	response = &CreateDBInstancePlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
