package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCollection invokes the gpdb.CreateCollection API synchronously
func (client *Client) CreateCollection(request *CreateCollectionRequest) (response *CreateCollectionResponse, err error) {
	response = CreateCreateCollectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCollectionWithChan invokes the gpdb.CreateCollection API asynchronously
func (client *Client) CreateCollectionWithChan(request *CreateCollectionRequest) (<-chan *CreateCollectionResponse, <-chan error) {
	responseChan := make(chan *CreateCollectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCollection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCollectionWithCallback invokes the gpdb.CreateCollection API asynchronously
func (client *Client) CreateCollectionWithCallback(request *CreateCollectionRequest, callback func(response *CreateCollectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCollectionResponse
		var err error
		defer close(result)
		response, err = client.CreateCollection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCollectionRequest is the request struct for api CreateCollection
type CreateCollectionRequest struct {
	*requests.RpcRequest
	Metadata                string           `position:"Query" name:"Metadata"`
	FullTextRetrievalFields string           `position:"Query" name:"FullTextRetrievalFields"`
	ManagerAccount          string           `position:"Query" name:"ManagerAccount"`
	DBInstanceId            string           `position:"Query" name:"DBInstanceId"`
	Dimension               requests.Integer `position:"Query" name:"Dimension"`
	ManagerAccountPassword  string           `position:"Query" name:"ManagerAccountPassword"`
	Collection              string           `position:"Query" name:"Collection"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	Parser                  string           `position:"Query" name:"Parser"`
	Namespace               string           `position:"Query" name:"Namespace"`
}

// CreateCollectionResponse is the response struct for api CreateCollection
type CreateCollectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateCreateCollectionRequest creates a request to invoke CreateCollection API
func CreateCreateCollectionRequest() (request *CreateCollectionRequest) {
	request = &CreateCollectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "CreateCollection", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCollectionResponse creates a response to parse from CreateCollection response
func CreateCreateCollectionResponse() (response *CreateCollectionResponse) {
	response = &CreateCollectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
