package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAccountFactoryBaseline invokes the governance.UpdateAccountFactoryBaseline API synchronously
func (client *Client) UpdateAccountFactoryBaseline(request *UpdateAccountFactoryBaselineRequest) (response *UpdateAccountFactoryBaselineResponse, err error) {
	response = CreateUpdateAccountFactoryBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAccountFactoryBaselineWithChan invokes the governance.UpdateAccountFactoryBaseline API asynchronously
func (client *Client) UpdateAccountFactoryBaselineWithChan(request *UpdateAccountFactoryBaselineRequest) (<-chan *UpdateAccountFactoryBaselineResponse, <-chan error) {
	responseChan := make(chan *UpdateAccountFactoryBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAccountFactoryBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAccountFactoryBaselineWithCallback invokes the governance.UpdateAccountFactoryBaseline API asynchronously
func (client *Client) UpdateAccountFactoryBaselineWithCallback(request *UpdateAccountFactoryBaselineRequest, callback func(response *UpdateAccountFactoryBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAccountFactoryBaselineResponse
		var err error
		defer close(result)
		response, err = client.UpdateAccountFactoryBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAccountFactoryBaselineRequest is the request struct for api UpdateAccountFactoryBaseline
type UpdateAccountFactoryBaselineRequest struct {
	*requests.RpcRequest
	Description   string                                       `position:"Query" name:"Description"`
	BaselineName  string                                       `position:"Query" name:"BaselineName"`
	BaselineId    string                                       `position:"Query" name:"BaselineId"`
	BaselineItems *[]UpdateAccountFactoryBaselineBaselineItems `position:"Query" name:"BaselineItems"  type:"Repeated"`
}

// UpdateAccountFactoryBaselineBaselineItems is a repeated param struct in UpdateAccountFactoryBaselineRequest
type UpdateAccountFactoryBaselineBaselineItems struct {
	Name    string `name:"Name"`
	Config  string `name:"Config"`
	Version string `name:"Version"`
}

// UpdateAccountFactoryBaselineResponse is the response struct for api UpdateAccountFactoryBaseline
type UpdateAccountFactoryBaselineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAccountFactoryBaselineRequest creates a request to invoke UpdateAccountFactoryBaseline API
func CreateUpdateAccountFactoryBaselineRequest() (request *UpdateAccountFactoryBaselineRequest) {
	request = &UpdateAccountFactoryBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "UpdateAccountFactoryBaseline", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAccountFactoryBaselineResponse creates a response to parse from UpdateAccountFactoryBaseline response
func CreateUpdateAccountFactoryBaselineResponse() (response *UpdateAccountFactoryBaselineResponse) {
	response = &UpdateAccountFactoryBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
