package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountFactoryBaseline invokes the governance.GetAccountFactoryBaseline API synchronously
func (client *Client) GetAccountFactoryBaseline(request *GetAccountFactoryBaselineRequest) (response *GetAccountFactoryBaselineResponse, err error) {
	response = CreateGetAccountFactoryBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountFactoryBaselineWithChan invokes the governance.GetAccountFactoryBaseline API asynchronously
func (client *Client) GetAccountFactoryBaselineWithChan(request *GetAccountFactoryBaselineRequest) (<-chan *GetAccountFactoryBaselineResponse, <-chan error) {
	responseChan := make(chan *GetAccountFactoryBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountFactoryBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountFactoryBaselineWithCallback invokes the governance.GetAccountFactoryBaseline API asynchronously
func (client *Client) GetAccountFactoryBaselineWithCallback(request *GetAccountFactoryBaselineRequest, callback func(response *GetAccountFactoryBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountFactoryBaselineResponse
		var err error
		defer close(result)
		response, err = client.GetAccountFactoryBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountFactoryBaselineRequest is the request struct for api GetAccountFactoryBaseline
type GetAccountFactoryBaselineRequest struct {
	*requests.RpcRequest
	BaselineId string `position:"Query" name:"BaselineId"`
}

// GetAccountFactoryBaselineResponse is the response struct for api GetAccountFactoryBaseline
type GetAccountFactoryBaselineResponse struct {
	*responses.BaseResponse
	BaselineId    string         `json:"BaselineId" xml:"BaselineId"`
	BaselineName  string         `json:"BaselineName" xml:"BaselineName"`
	CreateTime    string         `json:"CreateTime" xml:"CreateTime"`
	Description   string         `json:"Description" xml:"Description"`
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	Type          string         `json:"Type" xml:"Type"`
	UpdateTime    string         `json:"UpdateTime" xml:"UpdateTime"`
	BaselineItems []BaselineItem `json:"BaselineItems" xml:"BaselineItems"`
}

// CreateGetAccountFactoryBaselineRequest creates a request to invoke GetAccountFactoryBaseline API
func CreateGetAccountFactoryBaselineRequest() (request *GetAccountFactoryBaselineRequest) {
	request = &GetAccountFactoryBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "GetAccountFactoryBaseline", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAccountFactoryBaselineResponse creates a response to parse from GetAccountFactoryBaseline response
func CreateGetAccountFactoryBaselineResponse() (response *GetAccountFactoryBaselineResponse) {
	response = &GetAccountFactoryBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
