package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnrollAccount invokes the governance.EnrollAccount API synchronously
func (client *Client) EnrollAccount(request *EnrollAccountRequest) (response *EnrollAccountResponse, err error) {
	response = CreateEnrollAccountResponse()
	err = client.DoAction(request, response)
	return
}

// EnrollAccountWithChan invokes the governance.EnrollAccount API asynchronously
func (client *Client) EnrollAccountWithChan(request *EnrollAccountRequest) (<-chan *EnrollAccountResponse, <-chan error) {
	responseChan := make(chan *EnrollAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnrollAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnrollAccountWithCallback invokes the governance.EnrollAccount API asynchronously
func (client *Client) EnrollAccountWithCallback(request *EnrollAccountRequest, callback func(response *EnrollAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnrollAccountResponse
		var err error
		defer close(result)
		response, err = client.EnrollAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnrollAccountRequest is the request struct for api EnrollAccount
type EnrollAccountRequest struct {
	*requests.RpcRequest
	FolderId          string                        `position:"Query" name:"FolderId"`
	PayerAccountUid   requests.Integer              `position:"Query" name:"PayerAccountUid"`
	AccountUid        requests.Integer              `position:"Query" name:"AccountUid"`
	AccountNamePrefix string                        `position:"Query" name:"AccountNamePrefix"`
	ResellAccountType string                        `position:"Query" name:"ResellAccountType"`
	BaselineId        string                        `position:"Query" name:"BaselineId"`
	BaselineItems     *[]EnrollAccountBaselineItems `position:"Query" name:"BaselineItems"  type:"Repeated"`
	DisplayName       string                        `position:"Query" name:"DisplayName"`
}

// EnrollAccountBaselineItems is a repeated param struct in EnrollAccountRequest
type EnrollAccountBaselineItems struct {
	Name    string `name:"Name"`
	Skip    string `name:"Skip"`
	Config  string `name:"Config"`
	Version string `name:"Version"`
}

// EnrollAccountResponse is the response struct for api EnrollAccount
type EnrollAccountResponse struct {
	*responses.BaseResponse
	AccountUid int64  `json:"AccountUid" xml:"AccountUid"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateEnrollAccountRequest creates a request to invoke EnrollAccount API
func CreateEnrollAccountRequest() (request *EnrollAccountRequest) {
	request = &EnrollAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "EnrollAccount", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnrollAccountResponse creates a response to parse from EnrollAccount response
func CreateEnrollAccountResponse() (response *EnrollAccountResponse) {
	response = &EnrollAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
