package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstance invokes the foas.ListInstance API synchronously
func (client *Client) ListInstance(request *ListInstanceRequest) (response *ListInstanceResponse, err error) {
	response = CreateListInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceWithChan invokes the foas.ListInstance API asynchronously
func (client *Client) ListInstanceWithChan(request *ListInstanceRequest) (<-chan *ListInstanceResponse, <-chan error) {
	responseChan := make(chan *ListInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceWithCallback invokes the foas.ListInstance API asynchronously
func (client *Client) ListInstanceWithCallback(request *ListInstanceRequest, callback func(response *ListInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceRequest is the request struct for api ListInstance
type ListInstanceRequest struct {
	*requests.RoaRequest
	ProjectName  string           `position:"Path" name:"projectName"`
	EndBeginTs   requests.Integer `position:"Query" name:"endBeginTs"`
	ExpectState  string           `position:"Query" name:"expectState"`
	JobType      string           `position:"Query" name:"jobType"`
	ApiType      string           `position:"Query" name:"apiType"`
	ActualState  string           `position:"Query" name:"actualState"`
	EndEndTs     requests.Integer `position:"Query" name:"endEndTs"`
	StartEndTs   requests.Integer `position:"Query" name:"startEndTs"`
	PageSize     requests.Integer `position:"Query" name:"pageSize"`
	StartBeginTs requests.Integer `position:"Query" name:"startBeginTs"`
	PageIndex    requests.Integer `position:"Query" name:"pageIndex"`
	IsArchived   requests.Boolean `position:"Query" name:"isArchived"`
	JobName      string           `position:"Query" name:"jobName"`
}

// ListInstanceResponse is the response struct for api ListInstance
type ListInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	PageIndex  int       `json:"PageIndex" xml:"PageIndex"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	TotalPage  int       `json:"TotalPage" xml:"TotalPage"`
	TotalCount int64     `json:"TotalCount" xml:"TotalCount"`
	Instances  Instances `json:"Instances" xml:"Instances"`
}

// CreateListInstanceRequest creates a request to invoke ListInstance API
func CreateListInstanceRequest() (request *ListInstanceRequest) {
	request = &ListInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ListInstance", "/api/v2/projects/[projectName]/instances", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListInstanceResponse creates a response to parse from ListInstance response
func CreateListInstanceResponse() (response *ListInstanceResponse) {
	response = &ListInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
