package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchAddFaces invokes the facebody.BatchAddFaces API synchronously
func (client *Client) BatchAddFaces(request *BatchAddFacesRequest) (response *BatchAddFacesResponse, err error) {
	response = CreateBatchAddFacesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchAddFacesWithChan invokes the facebody.BatchAddFaces API asynchronously
func (client *Client) BatchAddFacesWithChan(request *BatchAddFacesRequest) (<-chan *BatchAddFacesResponse, <-chan error) {
	responseChan := make(chan *BatchAddFacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchAddFaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchAddFacesWithCallback invokes the facebody.BatchAddFaces API asynchronously
func (client *Client) BatchAddFacesWithCallback(request *BatchAddFacesRequest, callback func(response *BatchAddFacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchAddFacesResponse
		var err error
		defer close(result)
		response, err = client.BatchAddFaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchAddFacesRequest is the request struct for api BatchAddFaces
type BatchAddFacesRequest struct {
	*requests.RpcRequest
	EntityId                              string                `position:"Body" name:"EntityId"`
	FormatResultToJson                    requests.Boolean      `position:"Query" name:"FormatResultToJson"`
	QualityScoreThreshold                 requests.Float        `position:"Body" name:"QualityScoreThreshold"`
	SimilarityScoreThresholdBetweenEntity requests.Float        `position:"Body" name:"SimilarityScoreThresholdBetweenEntity"`
	OssFile                               string                `position:"Query" name:"OssFile"`
	SimilarityScoreThresholdInEntity      requests.Float        `position:"Body" name:"SimilarityScoreThresholdInEntity"`
	RequestProxyBy                        string                `position:"Query" name:"RequestProxyBy"`
	DbName                                string                `position:"Body" name:"DbName"`
	Faces                                 *[]BatchAddFacesFaces `position:"Body" name:"Faces"  type:"Json"`
}

// BatchAddFacesFaces is a repeated param struct in BatchAddFacesRequest
type BatchAddFacesFaces struct {
	ExtraData string `name:"ExtraData"`
	ImageURL  string `name:"ImageURL"`
}

// BatchAddFacesResponse is the response struct for api BatchAddFaces
type BatchAddFacesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBatchAddFacesRequest creates a request to invoke BatchAddFaces API
func CreateBatchAddFacesRequest() (request *BatchAddFacesRequest) {
	request = &BatchAddFacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "BatchAddFaces", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchAddFacesResponse creates a response to parse from BatchAddFaces response
func CreateBatchAddFacesResponse() (response *BatchAddFacesResponse) {
	response = &BatchAddFacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
