package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTracedEventByEventId invokes the eventbridge.QueryTracedEventByEventId API synchronously
func (client *Client) QueryTracedEventByEventId(request *QueryTracedEventByEventIdRequest) (response *QueryTracedEventByEventIdResponse, err error) {
	response = CreateQueryTracedEventByEventIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTracedEventByEventIdWithChan invokes the eventbridge.QueryTracedEventByEventId API asynchronously
func (client *Client) QueryTracedEventByEventIdWithChan(request *QueryTracedEventByEventIdRequest) (<-chan *QueryTracedEventByEventIdResponse, <-chan error) {
	responseChan := make(chan *QueryTracedEventByEventIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTracedEventByEventId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTracedEventByEventIdWithCallback invokes the eventbridge.QueryTracedEventByEventId API asynchronously
func (client *Client) QueryTracedEventByEventIdWithCallback(request *QueryTracedEventByEventIdRequest, callback func(response *QueryTracedEventByEventIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTracedEventByEventIdResponse
		var err error
		defer close(result)
		response, err = client.QueryTracedEventByEventId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTracedEventByEventIdRequest is the request struct for api QueryTracedEventByEventId
type QueryTracedEventByEventIdRequest struct {
	*requests.RpcRequest
	EventId      string `position:"Query" name:"EventId"`
	EventBusName string `position:"Query" name:"EventBusName"`
	EventSource  string `position:"Query" name:"EventSource"`
}

// QueryTracedEventByEventIdResponse is the response struct for api QueryTracedEventByEventId
type QueryTracedEventByEventIdResponse struct {
	*responses.BaseResponse
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryTracedEventByEventIdRequest creates a request to invoke QueryTracedEventByEventId API
func CreateQueryTracedEventByEventIdRequest() (request *QueryTracedEventByEventIdRequest) {
	request = &QueryTracedEventByEventIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "QueryTracedEventByEventId", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryTracedEventByEventIdResponse creates a response to parse from QueryTracedEventByEventId response
func CreateQueryTracedEventByEventIdResponse() (response *QueryTracedEventByEventIdResponse) {
	response = &QueryTracedEventByEventIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
