package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEventStreaming invokes the eventbridge.GetEventStreaming API synchronously
func (client *Client) GetEventStreaming(request *GetEventStreamingRequest) (response *GetEventStreamingResponse, err error) {
	response = CreateGetEventStreamingResponse()
	err = client.DoAction(request, response)
	return
}

// GetEventStreamingWithChan invokes the eventbridge.GetEventStreaming API asynchronously
func (client *Client) GetEventStreamingWithChan(request *GetEventStreamingRequest) (<-chan *GetEventStreamingResponse, <-chan error) {
	responseChan := make(chan *GetEventStreamingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEventStreaming(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEventStreamingWithCallback invokes the eventbridge.GetEventStreaming API asynchronously
func (client *Client) GetEventStreamingWithCallback(request *GetEventStreamingRequest, callback func(response *GetEventStreamingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEventStreamingResponse
		var err error
		defer close(result)
		response, err = client.GetEventStreaming(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEventStreamingRequest is the request struct for api GetEventStreaming
type GetEventStreamingRequest struct {
	*requests.RpcRequest
	EventStreamingName string `position:"Body" name:"EventStreamingName"`
}

// GetEventStreamingResponse is the response struct for api GetEventStreaming
type GetEventStreamingResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetEventStreamingRequest creates a request to invoke GetEventStreaming API
func CreateGetEventStreamingRequest() (request *GetEventStreamingRequest) {
	request = &GetEventStreamingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "GetEventStreaming", "", "")
	request.Method = requests.POST
	return
}

// CreateGetEventStreamingResponse creates a response to parse from GetEventStreaming response
func CreateGetEventStreamingResponse() (response *GetEventStreamingResponse) {
	response = &GetEventStreamingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
