package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachServerGroups invokes the ess.AttachServerGroups API synchronously
func (client *Client) AttachServerGroups(request *AttachServerGroupsRequest) (response *AttachServerGroupsResponse, err error) {
	response = CreateAttachServerGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// AttachServerGroupsWithChan invokes the ess.AttachServerGroups API asynchronously
func (client *Client) AttachServerGroupsWithChan(request *AttachServerGroupsRequest) (<-chan *AttachServerGroupsResponse, <-chan error) {
	responseChan := make(chan *AttachServerGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachServerGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachServerGroupsWithCallback invokes the ess.AttachServerGroups API asynchronously
func (client *Client) AttachServerGroupsWithCallback(request *AttachServerGroupsRequest, callback func(response *AttachServerGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachServerGroupsResponse
		var err error
		defer close(result)
		response, err = client.AttachServerGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachServerGroupsRequest is the request struct for api AttachServerGroups
type AttachServerGroupsRequest struct {
	*requests.RpcRequest
	ClientToken          string                           `position:"Query" name:"ClientToken"`
	ScalingGroupId       string                           `position:"Query" name:"ScalingGroupId"`
	ForceAttach          requests.Boolean                 `position:"Query" name:"ForceAttach"`
	ServerGroup          *[]AttachServerGroupsServerGroup `position:"Query" name:"ServerGroup"  type:"Repeated"`
	ResourceOwnerAccount string                           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer                 `position:"Query" name:"OwnerId"`
}

// AttachServerGroupsServerGroup is a repeated param struct in AttachServerGroupsRequest
type AttachServerGroupsServerGroup struct {
	ServerGroupId string `name:"ServerGroupId"`
	Port          string `name:"Port"`
	Weight        string `name:"Weight"`
	Type          string `name:"Type"`
}

// AttachServerGroupsResponse is the response struct for api AttachServerGroups
type AttachServerGroupsResponse struct {
	*responses.BaseResponse
	ScalingActivityId string `json:"ScalingActivityId" xml:"ScalingActivityId"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachServerGroupsRequest creates a request to invoke AttachServerGroups API
func CreateAttachServerGroupsRequest() (request *AttachServerGroupsRequest) {
	request = &AttachServerGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "AttachServerGroups", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachServerGroupsResponse creates a response to parse from AttachServerGroups response
func CreateAttachServerGroupsResponse() (response *AttachServerGroupsResponse) {
	response = &AttachServerGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
