package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachAlbServerGroups invokes the ess.AttachAlbServerGroups API synchronously
func (client *Client) AttachAlbServerGroups(request *AttachAlbServerGroupsRequest) (response *AttachAlbServerGroupsResponse, err error) {
	response = CreateAttachAlbServerGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// AttachAlbServerGroupsWithChan invokes the ess.AttachAlbServerGroups API asynchronously
func (client *Client) AttachAlbServerGroupsWithChan(request *AttachAlbServerGroupsRequest) (<-chan *AttachAlbServerGroupsResponse, <-chan error) {
	responseChan := make(chan *AttachAlbServerGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachAlbServerGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachAlbServerGroupsWithCallback invokes the ess.AttachAlbServerGroups API asynchronously
func (client *Client) AttachAlbServerGroupsWithCallback(request *AttachAlbServerGroupsRequest, callback func(response *AttachAlbServerGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachAlbServerGroupsResponse
		var err error
		defer close(result)
		response, err = client.AttachAlbServerGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachAlbServerGroupsRequest is the request struct for api AttachAlbServerGroups
type AttachAlbServerGroupsRequest struct {
	*requests.RpcRequest
	ClientToken          string                                 `position:"Query" name:"ClientToken"`
	ScalingGroupId       string                                 `position:"Query" name:"ScalingGroupId"`
	ForceAttach          requests.Boolean                       `position:"Query" name:"ForceAttach"`
	ResourceOwnerAccount string                                 `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer                       `position:"Query" name:"OwnerId"`
	AlbServerGroup       *[]AttachAlbServerGroupsAlbServerGroup `position:"Query" name:"AlbServerGroup"  type:"Repeated"`
}

// AttachAlbServerGroupsAlbServerGroup is a repeated param struct in AttachAlbServerGroupsRequest
type AttachAlbServerGroupsAlbServerGroup struct {
	AlbServerGroupId string `name:"AlbServerGroupId"`
	Port             string `name:"Port"`
	Weight           string `name:"Weight"`
}

// AttachAlbServerGroupsResponse is the response struct for api AttachAlbServerGroups
type AttachAlbServerGroupsResponse struct {
	*responses.BaseResponse
	ScalingActivityId string `json:"ScalingActivityId" xml:"ScalingActivityId"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachAlbServerGroupsRequest creates a request to invoke AttachAlbServerGroups API
func CreateAttachAlbServerGroupsRequest() (request *AttachAlbServerGroupsRequest) {
	request = &AttachAlbServerGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "AttachAlbServerGroups", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachAlbServerGroupsResponse creates a response to parse from AttachAlbServerGroups response
func CreateAttachAlbServerGroupsResponse() (response *AttachAlbServerGroupsResponse) {
	response = &AttachAlbServerGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
