package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetAICInstance invokes the ens.ResetAICInstance API synchronously
func (client *Client) ResetAICInstance(request *ResetAICInstanceRequest) (response *ResetAICInstanceResponse, err error) {
	response = CreateResetAICInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ResetAICInstanceWithChan invokes the ens.ResetAICInstance API asynchronously
func (client *Client) ResetAICInstanceWithChan(request *ResetAICInstanceRequest) (<-chan *ResetAICInstanceResponse, <-chan error) {
	responseChan := make(chan *ResetAICInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetAICInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetAICInstanceWithCallback invokes the ens.ResetAICInstance API asynchronously
func (client *Client) ResetAICInstanceWithCallback(request *ResetAICInstanceRequest, callback func(response *ResetAICInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetAICInstanceResponse
		var err error
		defer close(result)
		response, err = client.ResetAICInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetAICInstanceRequest is the request struct for api ResetAICInstance
type ResetAICInstanceRequest struct {
	*requests.RpcRequest
	ServerId   string `position:"Query" name:"ServerId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ResetAICInstanceResponse is the response struct for api ResetAICInstance
type ResetAICInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetAICInstanceRequest creates a request to invoke ResetAICInstance API
func CreateResetAICInstanceRequest() (request *ResetAICInstanceRequest) {
	request = &ResetAICInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ResetAICInstance", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateResetAICInstanceResponse creates a response to parse from ResetAICInstance response
func CreateResetAICInstanceResponse() (response *ResetAICInstanceResponse) {
	response = &ResetAICInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
