package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoadBalancerSpec invokes the ens.DescribeLoadBalancerSpec API synchronously
func (client *Client) DescribeLoadBalancerSpec(request *DescribeLoadBalancerSpecRequest) (response *DescribeLoadBalancerSpecResponse, err error) {
	response = CreateDescribeLoadBalancerSpecResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoadBalancerSpecWithChan invokes the ens.DescribeLoadBalancerSpec API asynchronously
func (client *Client) DescribeLoadBalancerSpecWithChan(request *DescribeLoadBalancerSpecRequest) (<-chan *DescribeLoadBalancerSpecResponse, <-chan error) {
	responseChan := make(chan *DescribeLoadBalancerSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoadBalancerSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoadBalancerSpecWithCallback invokes the ens.DescribeLoadBalancerSpec API asynchronously
func (client *Client) DescribeLoadBalancerSpecWithCallback(request *DescribeLoadBalancerSpecRequest, callback func(response *DescribeLoadBalancerSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoadBalancerSpecResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoadBalancerSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoadBalancerSpecRequest is the request struct for api DescribeLoadBalancerSpec
type DescribeLoadBalancerSpecRequest struct {
	*requests.RpcRequest
	LoadBalancerSpec string `position:"Query" name:"LoadBalancerSpec"`
}

// DescribeLoadBalancerSpecResponse is the response struct for api DescribeLoadBalancerSpec
type DescribeLoadBalancerSpecResponse struct {
	*responses.BaseResponse
	RequestId         string                  `json:"RequestId" xml:"RequestId"`
	PageNumber        int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize          int                     `json:"PageSize" xml:"PageSize"`
	TotalCount        int                     `json:"TotalCount" xml:"TotalCount"`
	LoadBalancerSpecs []LoadBalancerSpecsItem `json:"LoadBalancerSpecs" xml:"LoadBalancerSpecs"`
}

// CreateDescribeLoadBalancerSpecRequest creates a request to invoke DescribeLoadBalancerSpec API
func CreateDescribeLoadBalancerSpecRequest() (request *DescribeLoadBalancerSpecRequest) {
	request = &DescribeLoadBalancerSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeLoadBalancerSpec", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeLoadBalancerSpecResponse creates a response to parse from DescribeLoadBalancerSpec response
func CreateDescribeLoadBalancerSpecResponse() (response *DescribeLoadBalancerSpecResponse) {
	response = &DescribeLoadBalancerSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
