package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNetworkAcl invokes the ens.DeleteNetworkAcl API synchronously
func (client *Client) DeleteNetworkAcl(request *DeleteNetworkAclRequest) (response *DeleteNetworkAclResponse, err error) {
	response = CreateDeleteNetworkAclResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNetworkAclWithChan invokes the ens.DeleteNetworkAcl API asynchronously
func (client *Client) DeleteNetworkAclWithChan(request *DeleteNetworkAclRequest) (<-chan *DeleteNetworkAclResponse, <-chan error) {
	responseChan := make(chan *DeleteNetworkAclResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNetworkAcl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNetworkAclWithCallback invokes the ens.DeleteNetworkAcl API asynchronously
func (client *Client) DeleteNetworkAclWithCallback(request *DeleteNetworkAclRequest, callback func(response *DeleteNetworkAclResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNetworkAclResponse
		var err error
		defer close(result)
		response, err = client.DeleteNetworkAcl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNetworkAclRequest is the request struct for api DeleteNetworkAcl
type DeleteNetworkAclRequest struct {
	*requests.RpcRequest
	NetworkAclId string `position:"Query" name:"NetworkAclId"`
}

// DeleteNetworkAclResponse is the response struct for api DeleteNetworkAcl
type DeleteNetworkAclResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNetworkAclRequest creates a request to invoke DeleteNetworkAcl API
func CreateDeleteNetworkAclRequest() (request *DeleteNetworkAclRequest) {
	request = &DeleteNetworkAclRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteNetworkAcl", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNetworkAclResponse creates a response to parse from DeleteNetworkAcl response
func CreateDeleteNetworkAclResponse() (response *DeleteNetworkAclResponse) {
	response = &DeleteNetworkAclResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
