package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartFlow invokes the emr.StartFlow API synchronously
func (client *Client) StartFlow(request *StartFlowRequest) (response *StartFlowResponse, err error) {
	response = CreateStartFlowResponse()
	err = client.DoAction(request, response)
	return
}

// StartFlowWithChan invokes the emr.StartFlow API asynchronously
func (client *Client) StartFlowWithChan(request *StartFlowRequest) (<-chan *StartFlowResponse, <-chan error) {
	responseChan := make(chan *StartFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartFlowWithCallback invokes the emr.StartFlow API asynchronously
func (client *Client) StartFlowWithCallback(request *StartFlowRequest, callback func(response *StartFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartFlowResponse
		var err error
		defer close(result)
		response, err = client.StartFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartFlowRequest is the request struct for api StartFlow
type StartFlowRequest struct {
	*requests.RpcRequest
	FlowInstanceId string `position:"Query" name:"FlowInstanceId"`
	ProjectId      string `position:"Query" name:"ProjectId"`
}

// StartFlowResponse is the response struct for api StartFlow
type StartFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateStartFlowRequest creates a request to invoke StartFlow API
func CreateStartFlowRequest() (request *StartFlowRequest) {
	request = &StartFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "StartFlow", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartFlowResponse creates a response to parse from StartFlow response
func CreateStartFlowResponse() (response *StartFlowResponse) {
	response = &StartFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
