package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPipeline invokes the elasticsearch.ListPipeline API synchronously
func (client *Client) ListPipeline(request *ListPipelineRequest) (response *ListPipelineResponse, err error) {
	response = CreateListPipelineResponse()
	err = client.DoAction(request, response)
	return
}

// ListPipelineWithChan invokes the elasticsearch.ListPipeline API asynchronously
func (client *Client) ListPipelineWithChan(request *ListPipelineRequest) (<-chan *ListPipelineResponse, <-chan error) {
	responseChan := make(chan *ListPipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPipelineWithCallback invokes the elasticsearch.ListPipeline API asynchronously
func (client *Client) ListPipelineWithCallback(request *ListPipelineRequest, callback func(response *ListPipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPipelineResponse
		var err error
		defer close(result)
		response, err = client.ListPipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPipelineRequest is the request struct for api ListPipeline
type ListPipelineRequest struct {
	*requests.RoaRequest
	InstanceId string           `position:"Path" name:"InstanceId"`
	Size       requests.Integer `position:"Query" name:"size"`
	Page       requests.Integer `position:"Query" name:"page"`
	PipelineId string           `position:"Query" name:"pipelineId"`
}

// ListPipelineResponse is the response struct for api ListPipeline
type ListPipelineResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Headers   HeadersInListPipeline `json:"Headers" xml:"Headers"`
	Result    []ResultItem          `json:"Result" xml:"Result"`
}

// CreateListPipelineRequest creates a request to invoke ListPipeline API
func CreateListPipelineRequest() (request *ListPipelineRequest) {
	request = &ListPipelineRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListPipeline", "/openapi/logstashes/[InstanceId]/pipelines", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListPipelineResponse creates a response to parse from ListPipeline response
func CreateListPipelineResponse() (response *ListPipelineResponse) {
	response = &ListPipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
