package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstallAckOperator invokes the elasticsearch.InstallAckOperator API synchronously
func (client *Client) InstallAckOperator(request *InstallAckOperatorRequest) (response *InstallAckOperatorResponse, err error) {
	response = CreateInstallAckOperatorResponse()
	err = client.DoAction(request, response)
	return
}

// InstallAckOperatorWithChan invokes the elasticsearch.InstallAckOperator API asynchronously
func (client *Client) InstallAckOperatorWithChan(request *InstallAckOperatorRequest) (<-chan *InstallAckOperatorResponse, <-chan error) {
	responseChan := make(chan *InstallAckOperatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstallAckOperator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstallAckOperatorWithCallback invokes the elasticsearch.InstallAckOperator API asynchronously
func (client *Client) InstallAckOperatorWithCallback(request *InstallAckOperatorRequest, callback func(response *InstallAckOperatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstallAckOperatorResponse
		var err error
		defer close(result)
		response, err = client.InstallAckOperator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstallAckOperatorRequest is the request struct for api InstallAckOperator
type InstallAckOperatorRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	ClusterId   string `position:"Path" name:"ClusterId"`
	Body        string `position:"Body" name:"body"`
}

// InstallAckOperatorResponse is the response struct for api InstallAckOperator
type InstallAckOperatorResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInstallAckOperatorRequest creates a request to invoke InstallAckOperator API
func CreateInstallAckOperatorRequest() (request *InstallAckOperatorRequest) {
	request = &InstallAckOperatorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "InstallAckOperator", "/openapi/ack-clusters/[ClusterId]/operator", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInstallAckOperatorResponse creates a response to parse from InstallAckOperator response
func CreateInstallAckOperatorResponse() (response *InstallAckOperatorResponse) {
	response = &InstallAckOperatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
