package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDeprecatedTemplate invokes the elasticsearch.DescribeDeprecatedTemplate API synchronously
func (client *Client) DescribeDeprecatedTemplate(request *DescribeDeprecatedTemplateRequest) (response *DescribeDeprecatedTemplateResponse, err error) {
	response = CreateDescribeDeprecatedTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDeprecatedTemplateWithChan invokes the elasticsearch.DescribeDeprecatedTemplate API asynchronously
func (client *Client) DescribeDeprecatedTemplateWithChan(request *DescribeDeprecatedTemplateRequest) (<-chan *DescribeDeprecatedTemplateResponse, <-chan error) {
	responseChan := make(chan *DescribeDeprecatedTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDeprecatedTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDeprecatedTemplateWithCallback invokes the elasticsearch.DescribeDeprecatedTemplate API asynchronously
func (client *Client) DescribeDeprecatedTemplateWithCallback(request *DescribeDeprecatedTemplateRequest, callback func(response *DescribeDeprecatedTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDeprecatedTemplateResponse
		var err error
		defer close(result)
		response, err = client.DescribeDeprecatedTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDeprecatedTemplateRequest is the request struct for api DescribeDeprecatedTemplate
type DescribeDeprecatedTemplateRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"name"`
}

// DescribeDeprecatedTemplateResponse is the response struct for api DescribeDeprecatedTemplate
type DescribeDeprecatedTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeDeprecatedTemplateRequest creates a request to invoke DescribeDeprecatedTemplate API
func CreateDescribeDeprecatedTemplateRequest() (request *DescribeDeprecatedTemplateRequest) {
	request = &DescribeDeprecatedTemplateRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeDeprecatedTemplate", "/openapi/instances/[InstanceId]/deprecated-templates/[name]", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDeprecatedTemplateResponse creates a response to parse from DescribeDeprecatedTemplate response
func CreateDescribeDeprecatedTemplateResponse() (response *DescribeDeprecatedTemplateResponse) {
	response = &DescribeDeprecatedTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
