package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCollector invokes the elasticsearch.DescribeCollector API synchronously
func (client *Client) DescribeCollector(request *DescribeCollectorRequest) (response *DescribeCollectorResponse, err error) {
	response = CreateDescribeCollectorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCollectorWithChan invokes the elasticsearch.DescribeCollector API asynchronously
func (client *Client) DescribeCollectorWithChan(request *DescribeCollectorRequest) (<-chan *DescribeCollectorResponse, <-chan error) {
	responseChan := make(chan *DescribeCollectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCollector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCollectorWithCallback invokes the elasticsearch.DescribeCollector API asynchronously
func (client *Client) DescribeCollectorWithCallback(request *DescribeCollectorRequest, callback func(response *DescribeCollectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCollectorResponse
		var err error
		defer close(result)
		response, err = client.DescribeCollector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCollectorRequest is the request struct for api DescribeCollector
type DescribeCollectorRequest struct {
	*requests.RoaRequest
	ResId string `position:"Path" name:"ResId"`
}

// DescribeCollectorResponse is the response struct for api DescribeCollector
type DescribeCollectorResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Result    ResultInDescribeCollector `json:"Result" xml:"Result"`
}

// CreateDescribeCollectorRequest creates a request to invoke DescribeCollector API
func CreateDescribeCollectorRequest() (request *DescribeCollectorRequest) {
	request = &DescribeCollectorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeCollector", "/openapi/collectors/[ResId]", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeCollectorResponse creates a response to parse from DescribeCollector response
func CreateDescribeCollectorResponse() (response *DescribeCollectorResponse) {
	response = &DescribeCollectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
