package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnAssociateVpdCidrBlock invokes the eflo.UnAssociateVpdCidrBlock API synchronously
func (client *Client) UnAssociateVpdCidrBlock(request *UnAssociateVpdCidrBlockRequest) (response *UnAssociateVpdCidrBlockResponse, err error) {
	response = CreateUnAssociateVpdCidrBlockResponse()
	err = client.DoAction(request, response)
	return
}

// UnAssociateVpdCidrBlockWithChan invokes the eflo.UnAssociateVpdCidrBlock API asynchronously
func (client *Client) UnAssociateVpdCidrBlockWithChan(request *UnAssociateVpdCidrBlockRequest) (<-chan *UnAssociateVpdCidrBlockResponse, <-chan error) {
	responseChan := make(chan *UnAssociateVpdCidrBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnAssociateVpdCidrBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnAssociateVpdCidrBlockWithCallback invokes the eflo.UnAssociateVpdCidrBlock API asynchronously
func (client *Client) UnAssociateVpdCidrBlockWithCallback(request *UnAssociateVpdCidrBlockRequest, callback func(response *UnAssociateVpdCidrBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnAssociateVpdCidrBlockResponse
		var err error
		defer close(result)
		response, err = client.UnAssociateVpdCidrBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnAssociateVpdCidrBlockRequest is the request struct for api UnAssociateVpdCidrBlock
type UnAssociateVpdCidrBlockRequest struct {
	*requests.RpcRequest
	VpdId              string `position:"Body" name:"VpdId"`
	SecondaryCidrBlock string `position:"Body" name:"SecondaryCidrBlock"`
}

// UnAssociateVpdCidrBlockResponse is the response struct for api UnAssociateVpdCidrBlock
type UnAssociateVpdCidrBlockResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateUnAssociateVpdCidrBlockRequest creates a request to invoke UnAssociateVpdCidrBlock API
func CreateUnAssociateVpdCidrBlockRequest() (request *UnAssociateVpdCidrBlockRequest) {
	request = &UnAssociateVpdCidrBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "UnAssociateVpdCidrBlock", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnAssociateVpdCidrBlockResponse creates a response to parse from UnAssociateVpdCidrBlock response
func CreateUnAssociateVpdCidrBlockResponse() (response *UnAssociateVpdCidrBlockResponse) {
	response = &UnAssociateVpdCidrBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
