package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateVpdCidrBlock invokes the eflo.AssociateVpdCidrBlock API synchronously
func (client *Client) AssociateVpdCidrBlock(request *AssociateVpdCidrBlockRequest) (response *AssociateVpdCidrBlockResponse, err error) {
	response = CreateAssociateVpdCidrBlockResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateVpdCidrBlockWithChan invokes the eflo.AssociateVpdCidrBlock API asynchronously
func (client *Client) AssociateVpdCidrBlockWithChan(request *AssociateVpdCidrBlockRequest) (<-chan *AssociateVpdCidrBlockResponse, <-chan error) {
	responseChan := make(chan *AssociateVpdCidrBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateVpdCidrBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateVpdCidrBlockWithCallback invokes the eflo.AssociateVpdCidrBlock API asynchronously
func (client *Client) AssociateVpdCidrBlockWithCallback(request *AssociateVpdCidrBlockRequest, callback func(response *AssociateVpdCidrBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateVpdCidrBlockResponse
		var err error
		defer close(result)
		response, err = client.AssociateVpdCidrBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateVpdCidrBlockRequest is the request struct for api AssociateVpdCidrBlock
type AssociateVpdCidrBlockRequest struct {
	*requests.RpcRequest
	VpdId              string `position:"Body" name:"VpdId"`
	SecondaryCidrBlock string `position:"Body" name:"SecondaryCidrBlock"`
}

// AssociateVpdCidrBlockResponse is the response struct for api AssociateVpdCidrBlock
type AssociateVpdCidrBlockResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateAssociateVpdCidrBlockRequest creates a request to invoke AssociateVpdCidrBlock API
func CreateAssociateVpdCidrBlockRequest() (request *AssociateVpdCidrBlockRequest) {
	request = &AssociateVpdCidrBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "AssociateVpdCidrBlock", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateVpdCidrBlockResponse creates a response to parse from AssociateVpdCidrBlock response
func CreateAssociateVpdCidrBlockResponse() (response *AssociateVpdCidrBlockResponse) {
	response = &AssociateVpdCidrBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
